package com.pcloud.book.keywords.dto;

import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.math.BigDecimal;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author 杨涛
 * @description 资源服务
 * @date 2019/7/17 18:38
 */
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ServiceResourceDTO implements Serializable {
    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("具体类型")
    private String fromType;

    @ApiModelProperty("来源标识")
    private Long fromId;

    @ApiModelProperty("封面图")
    private String coverImg;

    @ApiModelProperty("跳转链接")
    private String url;

    @ApiModelProperty("短名称")
    private String shortName;

    @ApiModelProperty("类型（商品或应用）")
    private String typeCode;

    @ApiModelProperty("关键词")
    private String keyword;

    @ApiModelProperty("渠道ID")
    private Long channelId;
}
