package com.pcloud.book.push.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.pcloud.book.push.entity.PushItem;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/5/9 16:33
 **/
@JsonInclude(JsonInclude.Include.NON_NULL)
public class PushRecordDTO implements Serializable {
    private static final long serialVersionUID = -7787340422313203965L;

    @ApiModelProperty("群发记录id")
    private Long id;

    @ApiModelProperty("群发标识")
    private Long pushId;

    @ApiModelProperty("发送类型（1:立即发送 2:单次发送 3:每天发送）")
    private Integer pushType;

    @ApiModelProperty("发送时间")
    private Date pushTime;

    @ApiModelProperty("发送状态（1发送中 2发送成功 3发送失败 4部分成功）")
    private Integer pushStatus;

    @ApiModelProperty("是否删除")
    private Boolean isDelete;

    @ApiModelProperty("创建人")
    private Long createUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改人")
    private Long updateUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("推送消息项集合")
    private List<PushItem> pushItems;

    @ApiModelProperty("涉及群数量")
    private Integer groupCount;

    @ApiModelProperty("群发项数量")
    private Integer itemCount;

    @ApiModelProperty("群发类型集合")
    private List<String> itemTypes;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPushId() {
        return pushId;
    }

    public void setPushId(Long pushId) {
        this.pushId = pushId;
    }

    public Integer getPushType() {
        return pushType;
    }

    public void setPushType(Integer pushType) {
        this.pushType = pushType;
    }

    public Date getPushTime() {
        return pushTime;
    }

    public void setPushTime(Date pushTime) {
        this.pushTime = pushTime;
    }

    public Integer getPushStatus() {
        return pushStatus;
    }

    public void setPushStatus(Integer pushStatus) {
        this.pushStatus = pushStatus;
    }

    public Boolean getDelete() {
        return isDelete;
    }

    public void setDelete(Boolean delete) {
        isDelete = delete;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(Long updateUser) {
        this.updateUser = updateUser;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public List<PushItem> getPushItems() {
        return pushItems;
    }

    public void setPushItems(List<PushItem> pushItems) {
        this.pushItems = pushItems;
    }

    public Integer getGroupCount() {
        return groupCount;
    }

    public void setGroupCount(Integer groupCount) {
        this.groupCount = groupCount;
    }

    public Integer getItemCount() {
        return itemCount;
    }

    public void setItemCount(Integer itemCount) {
        this.itemCount = itemCount;
    }

    public List<String> getItemTypes() {
        return itemTypes;
    }

    public void setItemTypes(List<String> itemTypes) {
        this.itemTypes = itemTypes;
    }

    @Override
    public String toString() {
        return "PushRecordDTO{" +
                "id=" + id +
                ", pushId=" + pushId +
                ", pushType=" + pushType +
                ", pushTime=" + pushTime +
                ", pushStatus=" + pushStatus +
                ", isDelete=" + isDelete +
                ", createUser=" + createUser +
                ", createTime=" + createTime +
                ", updateUser=" + updateUser +
                ", updateTime=" + updateTime +
                ", pushItems=" + pushItems +
                ", groupCount=" + groupCount +
                ", itemCount=" + itemCount +
                ", itemTypes=" + itemTypes +
                '}';
    }
}
