package com.pcloud.book.timecontrol.vo.request;

import com.pcloud.book.timecontrol.entity.TimeControlPrizeItem;
import com.pcloud.book.timecontrol.enums.TaskPrizeItemTypeEnum;
import com.pcloud.common.utils.BeanUtils;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class PrizeCouponRequestVO {
    @NotNull(message = "优惠券链接不能为空")
    private String couponUrl;
    @NotNull(message = "优惠券标题不能为空")
    private String couponTitle;

    public static TimeControlPrizeItem valueToPrizeItem(SavePrize4TaskItemVO savePrize4TaskItemVO){
        TimeControlPrizeItem prizeItem = new TimeControlPrizeItem();
        PrizeCouponRequestVO vo = savePrize4TaskItemVO.getCoupon();
        BeanUtils.copyProperties(vo, prizeItem);
        prizeItem.setTaskId(savePrize4TaskItemVO.getTaskId());
        prizeItem.setTaskItemId(savePrize4TaskItemVO.getTaskItemId());
        prizeItem.setPrizeType(TaskPrizeItemTypeEnum.COUPON.key);
        prizeItem.setCreateTime(new Date());
        return prizeItem;
    }
}
