package com.pcloud.book.util.common;

import java.util.*;

import com.pcloud.common.utils.DateNewUtils;
import com.pcloud.common.utils.ListUtils;

/**
 * @author PENG
 * @version 1.0
 * @description 通用Utils
 * @date 2017年6月14日 下午2:11:50
 */
public class CommonUtils {

    /**
     * Long数字转字符串
     * @param number Long数字
     * @return
     * @author PENG
     */
    public static String longToString(Long number) {
        return number == null ? "0" : number.toString();
    }

    /**
     * 获取Boolean类型的值（处理为null的情况）
     * @param value Boolean值
     * @return
     */
    public static Boolean getBooleanValue(Boolean value) {
        return value == null ? false : value;
    }

    /**
     * 两个时间之间的秒数
     * @param date1 时间1
     * @param date2 时间2
     * @return
     * @author PENG
     */
    public static Integer subSecond(Date date1, Date date2) {
        long d1 = date1.getTime();
        long d2 = date2.getTime();
        int sub = (int) ((d1 - d2) / 1000);
        return sub;
    }

    /**
     * 获取今日所剩秒数
     * @return
     * @author PENG
     */
    public static Integer todayRemainingSeconds() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(Calendar.HOUR_OF_DAY, 23);
        cal.set(Calendar.MINUTE, 59);
        cal.set(Calendar.SECOND, 59);
        Integer second = subSecond(cal.getTime(), new Date());
        if (second <= 0) {
            second = 1;
        }
        return second;
    }

    /**
     * 收集起始时间到结束时间之间所有的时间并以字符串集合方式返回
     * @param timeStart 开始时间
     * @param timeEnd   截止时间
     * @return
     * @author PENG
     */
    public static List<String> collectLocalDates(Date timeStart, Date timeEnd) {
        List<String> result = new ArrayList<>();
        Calendar start = Calendar.getInstance();
        start.setTime(timeStart);
        Calendar end = Calendar.getInstance();
        end.setTime(timeEnd);
        while (start.before(end) || start.equals(end)) {
            result.add(DateNewUtils.getShortDateStr(start.getTime()));
            start.add(Calendar.DAY_OF_YEAR, 1);
        }
        return result;
    }

    /**
     * 收集起始时间到结束时间之间所有的时间并以字符串集合方式返回
     * @param timeStart 开始时间
     * @param timeEnd   截止时间
     * @return
     * @author PENG
     */
    public static List<String> collectLocalDates(String timeStart, String timeEnd) {
        Date startDate = DateNewUtils.getDateByStr(timeStart);
        Date endDate = DateNewUtils.getDateByStr(timeEnd);
        return collectLocalDates(startDate, endDate);
    }

    /**
     * 获取两个集合中相同元素
     * @param oldList
     * @param newList
     * @return
     */
    public static List<Long> getSameEle(List<Long> oldList,List<Long> newList){
        if(ListUtils.isEmpty(oldList)){
            return null;
        }
        if(ListUtils.isEmpty(newList)){
            return null;
        }
        List<Long> result = new LinkedList<>();
        List<Long> maxList = oldList;
        List<Long> minList = newList;
        if(maxList.size() < minList.size()){
            maxList = newList;
            minList = oldList;
        }
        Map<Long, Integer> map = new HashMap<Long, Integer>(maxList.size());
        for (Long id:maxList) {
            map.put(id,1);
        }
        for (Long id:minList) {
            if(null != map.get(id)){
                result.add(id);
            }
        }
        return result;
    }
}
