package com.pcloud.book.advertising.enums;

/**
 * Description 广告位置枚举
 * @author PENG
 * @date 2019/3/1
 */
public enum AdPositionEnum {

    BOOK_GROUP_PAGE("BOOK_GROUP_PAGE", "扫社群码页面"),

    APP_OR_PRODUCT("APP_OR_PRODUCT", "具体应用/作品"),

    WECHAT_GROUP_MSG("WECHAT_GROUP_MSG", "微信群消息");

    public final String positionCode;
    public final String positionName;

    AdPositionEnum(String positionCode, String positionName) {
        this.positionCode = positionCode;
        this.positionName = positionName;
    }

    /**
     * 校验位置是否存在
     */
    public static Boolean checkCodeExist(String positionCode) {
        AdPositionEnum[] var1 = values();
        int var2 = var1.length;
        for (int var3 = 0; var3 < var2; ++var3) {
            AdPositionEnum adPositionEnum = var1[var3];
            if (adPositionEnum.positionCode.equals(positionCode)) {
                return true;
            }
        }
        return false;
    }

    /**
     * 根据编码拿名称
     */
    public static String getNameByCode(String positionCode) {
        AdPositionEnum[] var1 = values();
        int var2 = var1.length;
        for (int var3 = 0; var3 < var2; ++var3) {
            AdPositionEnum adPositionEnum = var1[var3];
            if (adPositionEnum.positionCode.equals(positionCode)) {
                return adPositionEnum.positionName;
            }
        }
        return "";
    }

    public static final String[] AD_POSITION_GATHER = {BOOK_GROUP_PAGE.positionCode, APP_OR_PRODUCT.positionCode, WECHAT_GROUP_MSG.positionCode};
}
