/**
 * 
 */
package com.pcloud.book.book.biz;

import com.pcloud.book.book.dto.*;
import com.pcloud.book.book.entity.Book;
import com.pcloud.book.book.entity.BookLabel;
import com.pcloud.book.book.entity.SeriesBookRecord;
import com.pcloud.book.book.vo.*;
import com.pcloud.book.book.vo.request.BookInfo4ScanCountRequestVO;
import com.pcloud.book.book.vo.request.BookQualifyInfoVO;
import com.pcloud.book.book.vo.request.BookSearchParamVO;
import com.pcloud.book.book.vo.request.SyncRelateDataToRaysVO;
import com.pcloud.book.book.vo.request.UpdateBookRobotProcessDto;
import com.pcloud.book.group.dto.BookGroupDTO;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBean;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * @描述：书籍业务层接口
 * @作者：songx
 * @创建时间：2016年12月23日,下午2:59:46 @版本：1.0
 */
public interface BookBiz {

	/**
	 * 创建书籍
	 * 
	 * @param book
	 *            图书基本信息
	 * @param systemCode 当事人角色
	 *            角色
	 * @param token
	 * @throws BizException
	 */
	BookDto create(Book book, String systemCode, String token) throws BizException;

	/**
	 * 修改书籍
	 * 
	 * @param book
	 *            图书基本信息
	 * @throws BizException
	 */
	void update(Book book) throws BizException;

	/**
	 * 修改书籍（编辑）
	 * @param book
	 *            图书基本信息
	 * @param token
	 * @throws BizException
	 */
	BookDto updateByAdviser(Book book, String token) throws BizException;

	/**
	 * 删除书籍
	 * 
	 * @param bookId
	 *            图书标识
	 * @param deleteUserId
	 *            删除用户标识
	 * @throws BizException
	 */
	void delete(Long bookId, Long deleteUserId) throws BizException;

	/**
	 * 批量删除书籍
	 * 
	 * @param bookIds
	 *            图书标识列表
	 * @param deleteUserId
	 *            删除人标识
	 * @return
	 */
	void deletes(String bookIds, Long deleteUserId) throws BizException;

	/**
	 * 获取书籍基础信息
	 * 
	 * @param bookId
	 *            图书标识
	 * @return
	 */
	BookDto getBaseById(Long bookId) throws BizException;

	/**
	 * 根据ISBN获取图书信息
	 * 
	 * @param isbn
	 * @param serialNumber
	 *            序列号
	 * @return
	 * @throws BizException
	 */
	BookDto getByIsbn(String isbn, String serialNumber) throws BizException;

	/**
	 * 判断ISBN是否存在
	 * 
	 * @param typeCode
	 *            图书标识
	 * @param isbn
	 * @param serialNumber
	 *            序列号
	 * @return
	 */
	Boolean isbnExists(String typeCode, String isbn, String serialNumber) throws BizException;

	/**
	 * 获取单个书籍基础信息(包含统计信息)
	 * 
	 * @param bookId
	 *            图书标识
	 * @param adviserId
	 *            编辑标识
	 * @param channelId
	 *            渠道标识
	 * @return
	 */
	BookDto getById(Long bookId, Long adviserId, Long channelId) throws BizException;

    /**
     * 获取单个书籍基础信息(包含统计信息)
     *
     * @param bookId
     *            图书标识
     * @param adviserId
     *            编辑标识
     * @param channelId
     *            渠道标识
     * @return
     */
    BookDto getById4Platform(Long bookId, Long adviserId, Long channelId) throws BizException;

    /**
	 * 批量获取书籍信息
	 * 
	 * @param bookIds
	 *            图书标识列表
	 * @return
	 * @throws BizException
	 */
	Map<Long, BookDto> getListByIds(List<Long> bookIds) throws BizException;

	/**
	 * 批量获取书籍信息（书名 与书刊序号 封面图）
	 * 
	 * @param bookIds
	 *            图书标识列表
	 * @return
	 * @throws BizException
	 */
	Map<Long, BookDto> listBaseByIds(List<Long> bookIds) throws BizException;

	/**
	 * 批量获取书籍信息
	 * @param bookDetialDTO
	 * @return
	 * @throws BizException
	 */
	Map<String, BookDto> listBookGroupByBookIds(MapResourceTotalCountDTO bookDetailDTO) throws BizException;

	/**
	 * 批量获取书籍信息（书名 分类ID）
	 * @param bookDetialDTO
	 * @return
	 * @throws BizException
	 */
	Map<String,BookDto> listDetailByIds(BookDetialDTO bookDetialDTO)throws BizException;

	/**
	 * 获取书籍列表(编辑)
	 * 
	 * @param paramMap
	 * @param pageParam
	 *            分页参数传递工具类
	 * @param adviserId
	 *            编辑标识
	 * @return
	 * @throws BizException
	 */
	PageBean getListPage4Adviser(Map<String, Object> paramMap, PageParam pageParam, Long adviserId, Integer hasQrcode,Integer appointBook) throws BizException;

	/**
	 * 首页展示正在做的图书
	 * @param adviserId
	 * @param num
	 * @param isPrint
	 * @return
	 * @throws BizException
	 */
	List<BookDto> getList4Adviser(Long adviserId, Integer num, Boolean isPrint, Boolean isApproval) throws BizException;
	/**
	 * 微信端获取书籍列表(编辑)
	 * 
	 * @param paramMap
	 * @param pageParam
	 *            分页参数传递工具类
	 * @param adviserId
	 *            编辑标识
	 * @return
	 * @throws BizException
	 */
	PageBean getListPage4Wechat(Map<String, Object> paramMap, PageParam pageParam, Long adviserId);

	/**
	 * 获取书籍详细信息
	 * 
	 * @param bookId
	 *            图书标识
	 * @param adviserId
	 *            编辑标识
	 * @param channelId
	 *            渠道标识
	 * @return
	 */
	BookDto getDetailById(Long bookId, Long adviserId, Long channelId) throws BizException;

	/**
	 * 根据名称获取ID
	 * 
	 * @param bookName
	 *            图书名称
	 * @return
	 */
	List<Long> getIdsByName(String bookName) throws BizException;
	
	/**
	 * 根据名称获取ID
	 * 
	 * @param bookName
	 *            图书名称
	 * @return
	 */
	List<Long> getIdsByName(String bookName, Long adviserId) throws BizException;

	/**
	 * 图书收益，获取单个书籍基础信息(包含统计信息)
	 * 
	 * @param bookId
	 *            图书标识
	 * @param adviserId
	 *            编辑标识
	 * @param channelId
	 *            渠道标识
	 * @return
	 */
	BookDto getById4Profit(Long bookId, Long adviserId, Long channelId) throws BizException;

	/**
	 * 判断ISBN是否存在,如果存在返回书籍信息
	 * 
	 * @param book
	 *            图书基本信息实体类
	 * @return
	 * @throws IOException
	 */
	BookDto isbnExistsOrGetInfo(Book book) throws BizException;

	/**
	 * 创建编辑书籍关联关系
	 * 
	 * @param book
	 *            图书基本信息实体类
	 * @param token
	 * @return
	 */
	void setBookAdviserRelation(Book book, String token);

	/**
	 * 获取书籍基本信息
	 * 
	 * @param bookId
	 *            图书标识
	 * @return
	 */
	BookDto getBaseInfoById4Wechat(Long bookId);

	/**
	 * 根据ISBN获取期刊分页列表
	 * 
	 * @param pageParam
	 *            分页参数传递工具类
	 * @param typeCode
	 *            类型编码
	 * @param isbn
	 *            ISBN号
	 * @param channelId
	 *            渠道ID
	 * @param wechatUserId
	 *            微信用户标识
	 * @return: PageBean
	 */
	PageBean getJournalPageByIsbn(PageParam pageParam, String typeCode, String isbn, Long channelId, Long wechatUserId);

	/**
	 * 获取书刊列表
	 * 
	 * @param pageParam
	 *            分页参数传递工具类
	 * @param channelId
	 *            渠道标识
	 * @param wechatUserId
	 *            微信用户标识
	 * @return
	 */
	PageBean listPage4Wechat(PageParam pageParam, Long channelId, Long wechatUserId);

	/**
	 * 根据ISBN码获取书籍详情（包含二维码个数，应用个数，商品个数）
	 * 
	 * @param isbn
	 * @param serialNumber
	 *            序列号
	 * @return
	 */
	BookDto getDetailByIsbn(String isbn, String serialNumber);

	/**
	 * 获取书刊信息
	 * 
	 * @param adviserId
	 *            编辑标识
	 * @param number
	 *            分页参数传递工具类
	 * @return
	 */
	List<Object> listBook(Long adviserId, Integer number);

	/**
	 * 修改书籍封面图
	 * 
	 * @param book
	 *            图书基本信息实体类
	 */
	void updateCoverImg(Book book);

	/**
	 * 书刊列表-出版端
	 * 
	 * @param pageParam
	 *            分页参数传递工具类
	 * @param paramMap
	 * @param agentId
	 *            代理标识
	 * @return
	 */
	PageBean listPage4Agent(PageParam pageParam, Map<String, Object> paramMap, Long agentId);

	/**
	 * 获取书刊信息-app 编辑
	 * 
	 * @param adviserId
	 *            编辑标识
	 * @param pageParam
	 *            分页参数传递工具类
	 * @return
	 */
	PageBean listBook4App(Long adviserId, PageParam pageParam, String bookName);

	/**
	 * 获取应用关联图书
	 * 
	 * @param appId
	 *            应用标识
	 * @param channelId
	 *            渠道标识
	 * @return
	 */
	List<BookDto> listBookByAppId(Long appId, Long channelId);

	/**
	 * 书刊回收站列表（30天内删除的书刊列表）
	 * 
	 * @param adviserId
	 *            编辑标识
	 * @param pageParam
	 *            分页参数传递工具类
	 * @return
	 */
	PageBean listPageDelete4Adviser(Long adviserId, PageParam pageParam);

	/**
	 * 获取图书关联统计个数(商品，应用，资源)
	 * 
	 * @param bookId
	 *            图书标识
	 * @param channelId
	 *            渠道标识
	 * @param adviserId
	 *            编辑标识
	 * @return
	 */
	BookAssocCount getCount4BookAssoc(Long bookId, Long channelId, Long adviserId);

	/**
	 * 导出出版下所有书刊excel表（出版端）
	 * 
	 * @param agentId
	 *            出版标识
	 */
	void exportBookToExcel(Long agentId);

	/**
	 * 根据isbn获取图书信息
	 * 
	 * @param isbn
	 * @return
	 */
	Map<Long, BookDto> listByIsbn(String isbn);

	/**
	 * 图书列表（平台端）
	 * 
	 * @param pageParam
	 *            分页参数传递工具类
	 * @param paramMap
	 * @return
	 */
	PageBean listBookClassify(PageParam pageParam, Map<String, Object> paramMap);


	/**
	 * 导出图书列表（平台端）
	 * @param paramMap
	 */
	void exportBookClassify(Map<String, Object> paramMap);

	/**
	 * 导出平台下所有书刊excel表（平台端）
	 */
	void exportBookToExcel4Platform();

	/**
	 * 获取图书基本信息（编辑 - 运营 - 图书）
	 * 
	 * @param adviserId
	 *            编辑标识
	 * @param channelId
	 *            运营标识
	 * @param bookId
	 *            图书标识
	 * @return
	 */
	BookDto getBookById(Long adviserId, Long channelId, Long bookId);

	/**
	 * 根据ISBN获取图书信息
	 * 
	 * @param isbn
	 * @param typeCode
	 * @return
	 * @throws BizException
	 */
	BookDto getByIsbnAndTypeCode(String isbn, String typeCode) throws BizException;
	
	/**
	 * 编辑新增图书
	 * @param book
	 *            图书基本信息
	 * @param token
	 * @return
	 */
	BookDto create4Adviser(Book book, String token);

	/**
	 * 修改图书类型与图书基本信息
	 * @param book
	 */
	void updateBookAndBookType(Book book);
	/**
	 * 校验书籍isbn码
	 * @param isbn
	 * @return
	 */
	Boolean checkISBN4App(String isbn);
	/**
	 * @param partyId	编辑ID
	 * @param channelId	渠道ID
	 * @param pageParam	分页参数
	 * @return
	 * @throws BizException
	 */
	PageBean getBookBaseInfoListByChannelId4Adviser(Long partyId,Long channelId,PageParam pageParam, String name) throws BizException;

	/**
	 * 修改时间
	 * @param bookId
	 * @throws BizException
	 */
	void updateTimeById(Long bookId)throws BizException;

	/**
	 * 根据ID批量修改时间
	 * @param bookAdviserUpdateTimeDTO
	 * @throws BizException
	 */
	void updateTimeByIds(BookAdviserUpdateTimeDTO bookAdviserUpdateTimeDTO)throws BizException;

	/**
	 * 获取书刊信息
	 * @return
	 * @throws BizException
	 */
	Map<String,BookInfoAnalysicsDTO> getBookInfoBy(List<BookInfoAnalysicsDTO> bookInfoAnalysicsDTOS,String monthDate)throws BizException;

	/**
	 * 获取图书分类标识
	 * @param adviserId
	 * @param channelId
	 * @param bookId
	 * @return
	 */
	Long getBookTempletIdId(Long adviserId, Long channelId, Long bookId);

	/**
	 * 获取书刊信息
	 * @param bookIds
	 * @param monthDate
	 * @return
	 * @throws BizException
	 */
	Map<Long,BookInfo4AnlysicsDTO> getBookAnalysis(List<Long> bookIds, String monthDate)throws BizException;

	/**
	 * 获取书刊基本信息
	 * @param pageParam
	 * @param name
	 * @return
	 * @throws BizException
	 */
	PageBean getListPage4PC(PageParam pageParam,String name)throws BizException;

	/**
	 * 获取未设置授权信息图书
	 * @param listNoAuthBookParam
	 * @return
	 */
    PageBeanNew listNoAuthBook(ListNoAuthBookParam listNoAuthBookParam, Long adviserId);

	/**
	 * 获取未设置授权的社群书
	 * @param listNoAuthGroupBookParam
	 * @param adviserId
	 * @return
	 */
	PageBeanNew listNoAuthGroupBook(ListNoAuthGroupBookParam listNoAuthGroupBookParam, Long adviserId);

	/**
	 * 获取图书基本信息与授权状态
	 */
	BookInfoAndAuthStatusDTO getBaseAndAuthStatus(Long bookId, Long channelId, Long adviserId);

	/**
	 * 根据书名或ISBN编号获取书id集合
	 */
	List<Long> getIdsByNameOrISBN(String keyword, Long adviserId);

	/**
	 * 获取1v1社群书书刊列表
	 * @param currentPage
	 * @param numPerPage
	 * @param name
	 * @param adviserId
	 * @return
	 */
	PageBeanNew<AdviserBookInfoDTO> getListPage4SelfBookGroup(Integer currentPage, Integer numPerPage, String name,Long adviserId, Long graLabelId, Long subLabelId, Long verLabelId, Long areaLabelId);

	/**
	 * 获取书籍标签
	 */
    Map<Integer,List<BookLabel>> getBookLabels(Long partyId);


	/**
	 * 书刊收益列表-出版端
	 */
	PageBeanNew<BookSaleVO> listPageIncomeDetail(PageParam pageParam, Map<String, Object> paramMap, Long agentId, String sortType);

	/**
	 * 时代大屏用
	 */
	PageBeanNew<BookSaleVO> listPageIncomeDetail4Times(PageParam pageParam, Map<String, Object> paramMap, Long agentId);

	/**
	 * 导出书刊收益--时代大屏用
	 */
	Map<String,Object> exportBookIncomeDetail4Times(Map<String, Object> paramMap, Long agentId);


	/**
	 * 导出书刊收益--出版端
	 */
	void exportBookIncomeDetail(Map<String, Object> paramMap, Long agentId, Long partyId, String systemCode);

	/**
	 * 根据书名模糊匹配，获得所有book_id
	 * @param bookName
	 * @return
	 */
	List<Long> getBookIdsByBookName(String bookName);

	/**
	 * 平台端获取编辑书刊
	 */
	PageBeanNew<BookDto> getAdviserBooks4Pcloud(String keyword, Long agentId, Long templetId, Long secondTempletId, Long thirdTempletId, String typeCode, Integer currentPage, Integer numPerPage);

	/**
	 * 获取编辑书刊H5
	 */
	PageBeanNew<BookDto> getAdviserBooks4H5(String grayStatus, String keyword, Long templetId, Long secondTempletId, Long thirdTempletId, Integer currentPage,
											Integer numPerPage);

	/**
	 *运营端获取书刊及配置资源
	 */
	PageBeanNew<BookDto> getBookAndServeList4Channel(Integer currentPage, Integer numPerPage, Long channelId,String name,
													 Integer isFundSupport, String startDate, String endDate);

	/**
	 * 根据isbn模糊匹配，获得所有book_id
	 */
	List<Long> getBookIdsByIsbn(String isbn);

	BookDto getAdviserBook(Long bookId, Long adviserId, Long channelId, Long sceneId);

	/**
	 * 批量更新质检书籍
	 */
    void updateBookQualifyInfo(BookQualifyInfoVO bookQualifyInfo, Long adviserId);

	PageBeanNew<BookQualifyVO> getAddBookQualifyList(Integer currentPage, Integer numPerPage, String name,Integer isShowQualifyInfo,Long adviserId);

	SearchBookVO getBookInfoByBookGroupId(Long bookGroupId);

	void updateIsOpenRobotProcess(Long adviserId, UpdateBookRobotProcessDto robotProcessDto);

	void updateIsOpenRobotProcess4Now(Long adviserId, UpdateBookRobotProcessDto robotProcessDto);

	PageBeanNew<BookDto> getAdviserBooks4Rights(String keyword, Long agentId, Long templetId, Long secondTempletId, String typeCode, Integer currentPage, Integer numPerPage, Integer isIgnore, Long thirdTempletId);

	void createBookGroupAppletUrl(Long bookId, Long channelId, Long adviserId,List<Long> sceneIds);
	/**
	 * 小程序首页书刊搜索
	 * @author：zhuyajie
	 * @date：2020/5/19 18:26
	 *  * @param null
	 */
	PageBeanNew<BookDto> getAdviserBooks4Applet(BookSearchParamVO bookSearchParamVO);

    Map<Integer,List<BookLabel>> getBookLabels4Erp();

	void relateUniqueNumber4Erp(List<BookUniqueNumberDTO> bookUniqueNumberVos);

	void relateBookAdviser4Erp(RelateAdviserVO relateAdviserVO);

	List<CreateBookResultVO> batchCreateBook4Erp(List<CreateBookVO> createBookVOList);

	void addCreateInfoToMq(List<CreateBookVO> createBookVOList);

	List<CreateBookResultVO> batchCreateBook4ErpNew(List<CreateBookVO> createBookVOList);

	BookDto getBaseById4Erp(Long bookId,Long channelId,Long adviserId);

	List<BookGroupDTO> getQrcode4Erp(Long bookId, Long channelId, Long adviserId, Long projectId);

	PageBeanNew<QrcodeServeDto> getQrcodeDetail4Erp(Long sceneId, Long bookGroupId, Long channelId, Integer currentPage, Integer numPerPage);

	BookGroupDTO checkQrcodeDetail4Erp(String url);

    Boolean checkIsLibraryBook(Long adviserId, Long bookId);

	/**
	 * 获取默认的权益ID
	 */
	Long getDefaultRightsSettingId();

	void clearCache4BookBaseInfo(String pwd);

	/**
	 * 获取书籍基本信息
	 * @param bookId
	 * @param adviserId
	 * @param channelId
	 * @return
	 */
	BookDto getBaseById4Buy(Long bookId, Long adviserId, Long channelId);

	void fillAgentSale(List<BookDto> bookDtos);
	/**
	 * 答案，搜索全平台书刊
	 * @author：zhuyajie
	 * @date：2020/11/4 14:13
	 *  * @param null
	 */
	PageBeanNew<BookDto> getESAdviserBooks4Answer(Long wechatUserId, BookSearchParamVO bookSearchParamVO);

	/**
	 * 系列书学科列表
	 * @author：zhuyajie
	 * @date：2020/11/23 15:46
	 *  * @param null
	 */
	List<BookLabelVO> getSubjectLabelList4SeriesBook(Long seriesBookId, Long graLabelId);

	/**
	 * 是否是系列书
	 * @author：zhuyajie
	 * @date：2020/11/23 17:07
	 *  * @param null
	 */
	Map<String, Object> isSeriesBook(Long bookId, Long adviserId, Long channelId);
	/**
	 * 根据学科查系列书
	 * @author：zhuyajie
	 * @date：2020/11/23 19:19
	 *  * @param null
	 */
	PageBeanNew<BookDto> getSeriesBookList(Long seriesBookId, Long subLabelId, Long graLabelId, Integer currentPage, Integer numPerPage, Long verLabelId, Long volLabelId, Long ignorSubLabelId);
	/**
	 * 系列书查询记录
	 * @author：zhuyajie
	 * @date：2020/11/25 10:23
	 *  * @param null
	 */
	void addSeriesBookRecord(SeriesBookRecord seriesBookRecord);

	BookDto createBook4Erp(Book book);

	/**
	 *版次分析
	 */
	EditionAnalysisResultVO bookEditionAnalysis(Long adviserId);

	/**
	 * 保底支持书刊
	 * @author：zhuyajie
	 * @date：2021/1/4 11:45
	 *  * @param null
	 */
	PageBeanNew<BookDto> listPageBookMinimunSupport4Platform(Integer currentPage, Integer numPerPage,
			String isbn, String bookName, String publish, String serialNumber, Integer isCurrentMonth, Integer isOverdue,
															 Long agentId) throws BizException;

	List<BookInfo4ScanCount> fetchBookListByScanCount(List<BookInfo4ScanCountRequestVO> requestVOS);

    BookCountsVO getPublishCounts(Long agentId,int month);
    /**
     * 添加书刊链接
     * @author：zhuyajie
     * @date：2021/4/1 10:02
     *  * @param null
     */
    void updateBookLink(BookLinkVO bookLinkVO, Long adviserId);
    /**
     * 查书刊链接
     * @author：zhuyajie
     * @date：2021/4/1 10:04
     *  * @param null
     */
    Map<Long, BookLinkVO> getBookLinkMap(Long adviserId, List<Long> bookIds);
    /**
     * 查书刊链接
     * @author：zhuyajie
     * @date：2021/4/1 16:01
     *  * @param null
     */
    List<BookLinkVO> getBookLink(Long adviserId, List<Long> bookIds);

    /**
     * 编辑端查所有书刊
     * @author：zhuyajie
     * @date：2021/4/16 14:31
     *  * @param null
     */
	PageBeanNew<BookDto> listAll4Adviser(BookSearchParamVO bookSearchParamVO);

	/**
	 * 查询首页统计数据
	 */
	Map<String, Object> getRaysHomePageStatistics(Long adviserId);

	/**
	 * 同步数据
	 * @param vo
	 */
    void syncRelateDataToRays(SyncRelateDataToRaysVO vo);

	/**
	 * 更新封面
	 */
	void updateCoverImg(SyncRelateDataToRaysVO vo);

    boolean checkIsBookId(Long isbnNumber);

    /**
     * 编辑图书
     * @author：zhuyajie
     * @date：2021/7/28 11:21
     *  * @param null
     */
	PageBean listAdviserBook(AviserBookInfoParam aviserBookInfoParam);

	void exportListPage4Agent(Map<String, Object> paramMap, Long agentId, Long partyId, String systemCode);

	/**
	 * 获取指定展示书刊(新手引导)
	 */
	List<Object> getAppointBooks(Long adviserId, Long channelId);

	/**
	 * 移除展示书刊(新手引导)
	 */
	void removeGuideBook(Long adviserId, Long bookId);

	/**
	 * 超过10人扫码书刊(新手引导)
	 */
	BookDto getOver10ScanBook(Long adviserId);

	/**
	 * 通过isbn，书名等信息去es库里面匹配图书封面
	 */
    List<String> listBookCover(String isbn, String bookName, String author, String publish);

	/**
	 * 从缓存中获取基本信息
	 * @param bookId
	 * @return
	 */
	BookDto getBookFromRedis(Long bookId);
}
