package com.pcloud.book.book.facade;

import com.pcloud.book.book.entity.BookFund;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.codehaus.jackson.JsonParseException;
import org.springframework.web.bind.annotation.*;

/**
 * @描述：书刊基金接口层
 * @作者：lihao
 * @创建时间：2017年7月19日,下午3:13:21 @版本：1.0
 */
@Api(description = "书刊基金接口外部服务")
public interface BookFundFacade {

    /**
     * @param token
     * @param bookFund
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     * @Title: create
     * @Description:创建书刊基金状态
     * @return: ResponseDto<?>
     * @author: lihao
     * @date: 2017年7月19日 下午5:29:56
     */
    @ApiOperation(value = "创建书刊基金状态", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookFund", value = "书刊基金实体", dataType = "BookFund", paramType = "body")})
    @RequestMapping(value = "create", method = RequestMethod.POST)
    public ResponseDto<?> create(@RequestHeader("token") String token, @RequestBody BookFund bookFund)
            throws BizException, PermissionException, JsonParseException;

    /**
     * @param token
     * @param bookFund
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     * @Title: update
     * @Description:修改书刊基金状态
     * @return: ResponseDto<?>
     * @author: lihao
     * @date: 2017年7月19日 下午5:29:56
     */
    @ApiOperation(value = "修改书刊基金状态", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookFund", value = "书刊基金实体", dataType = "BookFund", paramType = "body")})
    @RequestMapping(value = "update", method = RequestMethod.POST)
    public ResponseDto<?> update(@RequestHeader("token") String token, @RequestBody BookFund bookFund)
            throws BizException, PermissionException, JsonParseException;

    /**
     * @param token
     * @param bookId
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     * @Title: getByBookId
     * @Description:根据BookId获取基金状态
     * @return: ResponseDto<?>
     * @author: lihao
     * @date: 2017年7月19日 下午5:30:10
     */
    @ApiOperation(value = "根据BookId获取基金状态", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getByBookId", method = RequestMethod.GET)
    public ResponseDto<?> getByBookId(@RequestHeader("token") String token,
                                      @RequestParam(value = "bookId", required = false) Long bookId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * @param token
     * @param bookId
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     * @Title: getFundList4Adviser
     * @Description:编辑端获取书刊基金买断信息
     * @return: ResponseDto<?>
     * @author: lihao
     * @date: 2017年7月21日 下午1:01:56
     */
    @ApiOperation(value = "编辑端获取书刊基金买断信息", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getFundList4Adviser", method = RequestMethod.GET)
    public ResponseDto<?> getFundList4Adviser(@RequestHeader("token") String token,
                                              @RequestParam(value = "bookId", required = false) Long bookId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 分页获取基金图书状态
     *
     * @param token
     * @param bookId      图书标识
     * @param currentPage 当前页
     * @param numPerPage  每页条数
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "分页获取基金图书状态", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query")})
    @RequestMapping(value = "listByBookId", method = RequestMethod.GET)
    public ResponseDto<?> listByBookId(@RequestHeader("token") String token,
                                       @RequestParam(value = "bookId", required = false) Long bookId,
                                       @RequestParam(value = "currentPage", required = false) Integer currentPage,
                                       @RequestParam(value = "numPerPage", required = false) Integer numPerPage)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 获取书刊基金状态
     *
     * @param token
     * @param bookFundId
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "获取书刊基金状态", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookFundId", value = "图书基金标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getByBookFundId", method = RequestMethod.GET)
    public ResponseDto<?> getByBookFundId(@RequestHeader("token") String token, @RequestParam(value = "bookFundId", required = false) Long bookFundId)
            throws BizException, PermissionException, JsonParseException;

	/**
	 * 删除书刊基金
	 * 
	 * @param bookFundId
	 * @return
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 */
	@ApiOperation(value = "获取书刊基金状态", httpMethod = "GET")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "bookFundId", value = "图书基金标识", dataType = "long", paramType = "query") })
	@RequestMapping(value = "deleteById", method = RequestMethod.GET)
	ResponseDto<?> deleteById(@RequestParam(value = "bookFundId", required = false) Long bookFundId)
			throws BizException, PermissionException, JsonParseException;
}
