package com.pcloud.book.consumer.content;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.contentcenter.resource.dto.ResourceDTO;
import com.pcloud.contentcenter.resource.service.ResourceService;
import com.pcloud.resourcecenter.product.dto.ProductVideoScheduleDTO;
import com.pcloud.resourcecenter.product.dto.ProductVideoScheduleQueryDTO;
import com.pcloud.resourcecenter.product.service.ProductVideoScheduleService;


/**
  * 资源接口
  * @author  作者 : lili
  * @date 创建时间：2016年12月2日 下午7:09:15
  * @version 1.0 
  * @return 
  */
@Repository("resourceConsr")
public class ResourceConsr {
	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(ResourceConsr.class);

	@Autowired
	private ResourceService resourceService;
	@Autowired
	private ProductVideoScheduleService productVideoScheduleService;
	
	
	/**
	 * 获取资源基本信息
	 */
	public Map<Long,ResourceDTO> mapByPass(List<Long> resourceIds) throws BizException {
		LOGGER.info("获取资源基本信息[resourceService.mapByPass],参数列表[appIds]:" + resourceIds);
		Map<Long, ResourceDTO> resourceDtos =  new HashMap<>();
		if (ListUtils.isEmpty(resourceIds)) {
			return resourceDtos;
		}
		try {
			ResponseHandleUtil.parseMapResponse(resourceService.mapByPass(resourceIds, true, true), Long.class, ResourceDTO.class);
		} catch (BizException e) {
			LOGGER.warn("获取资源基本信息[resourceService.mapByPass]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("获取资源基本信息[resourceService.mapByPass]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_CONTENT_ERROR, "获取资源基本信息失败~!");
		}
		return resourceDtos;
	}
	
	/**
	 * 获取资源基本信息
	 */
	public Map<Long,ResourceDTO> mapByIds(List<Long> resourceIds) throws BizException {
		LOGGER.info("获取资源基本信息[resourceService.mapByIds],参数列表[appIds]:" + resourceIds);
		Map<Long, ResourceDTO> resourceDtos =  new HashMap<>();
		if (ListUtils.isEmpty(resourceIds)) {
			return resourceDtos;
		}
		try {
		   resourceDtos = ResponseHandleUtil.parseMapResponse(resourceService.mapByIds(resourceIds, true, true), Long.class, ResourceDTO.class);
		   LOGGER.info("获取资源基本信息【END】");
		} catch (BizException e) {
			LOGGER.warn("获取资源基本信息[resourceService.mapByIds]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("获取资源基本信息[resourceService.mapByIds]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_CONTENT_ERROR, "获取资源基本信息失败~!");
		}
		return resourceDtos;
	}

	@ParamLog("查视频课-上分mvp")
    public List<ProductVideoScheduleDTO> getProductVideoCourseList4ExerciseBook(ProductVideoScheduleQueryDTO productVideoScheduleQueryDTO) {
		List<ProductVideoScheduleDTO> list = new ArrayList<>();
		try {
			list = ResponseHandleUtil.parseList(productVideoScheduleService.getProductVideoCourseList4ExerciseBook(productVideoScheduleQueryDTO), ProductVideoScheduleDTO.class);
		} catch (Exception e) {
			LOGGER.error("调用失败" +e.getMessage(), e);
		}
		return list;
	}

	/**
	 * 获取资源基本信息
	 */
	public Map<Long,ResourceDTO> mapResourceByIds(List<Long> resourceIds,boolean isFileInfo, boolean isPdfImage) throws BizException {
		LOGGER.info("获取资源基本信息[resourceService.mapByIds],参数列表[resourceIds]:" + resourceIds);
		Map<Long, ResourceDTO> resourceDtos =  new HashMap<>();
		if (ListUtils.isEmpty(resourceIds)) {
			return resourceDtos;
		}
		try {
			resourceDtos = ResponseHandleUtil.parseMapResponse(resourceService.mapByIds(resourceIds, isFileInfo, isPdfImage), Long.class, ResourceDTO.class);
			LOGGER.info("获取资源基本信息【END】");
		} catch (Exception e) {
			LOGGER.error("获取资源基本信息[resourceService.mapByIds]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_CONTENT_ERROR, "获取资源基本信息失败~!");
		}
		return resourceDtos;
	}
}
