package com.pcloud.book.group.biz.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.pcloud.book.consumer.user.ChannelConsr;
import com.pcloud.book.group.biz.MultiChannelContentBiz;
import com.pcloud.book.group.biz.MultiChannelContentItemBiz;
import com.pcloud.book.group.dao.MultiChannelContentDao;
import com.pcloud.book.group.dto.MultiChannelContentDTO;
import com.pcloud.book.group.dto.MultiChannelContentItemDTO;
import com.pcloud.book.group.entity.MultiChannelContent;
import com.pcloud.book.group.entity.MultiChannelContentItem;
import com.pcloud.channelcenter.base.constants.ChannelTypeEnum;
import com.pcloud.channelcenter.channel.dto.BiliVideoDTO;
import com.pcloud.channelcenter.channel.dto.DouyinVideoDTO;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
 import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * (MultiChannelContent)表服务实现类
 *
 * @author wubo 
 * @since 2022-06-06 19:11:46
 */
@Service("multiChannelContentBiz")
public class MultiChannelContentBizImpl implements MultiChannelContentBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(MultiChannelContentBizImpl.class);

    @Autowired
    private MultiChannelContentDao multiChannelContentDao;
    @Autowired
    private MultiChannelContentItemBiz multiChannelContentItemBiz;
    @Autowired
    private ChannelConsr channelConsr;

    @Override
    @ParamLog("通过ID查询单条数据")
    public MultiChannelContent getById(Long id) {
        return multiChannelContentDao.getById(id);
    }

    @Override
    @ParamLog("查询多条数据")
    public PageBeanNew getList(Integer currentPage, Integer numPerPage) {
        PageBeanNew pageBeanNew = multiChannelContentDao.listPageNew(new PageParam(currentPage, numPerPage), null, "getList");
        List recordList = pageBeanNew.getRecordList();
        if (ListUtils.isEmpty(recordList)){
            return pageBeanNew;
        }
        // 加载其它数据
        
        return pageBeanNew;
    }

    @Override
    @ParamLog("新增")
    public Long insert(MultiChannelContent multiChannelContent) {
        multiChannelContentDao.insert(multiChannelContent);
        return multiChannelContent.getId();
    }

    @Override
    @ParamLog("修改")
    public void update(MultiChannelContent multiChannelContent) {
        if(multiChannelContent == null || !NumberUtil.isNumber(multiChannelContent.getId())){
            throw BizException.PARAM_IS_NULL;
        }
        multiChannelContentDao.update(multiChannelContent);
    }

    @Override
    @ParamLog("删除")
    public void deleteById(Long id) {
        multiChannelContentDao.deleteById(id);
    }
    
    @Override
    @ParamLog("软删除")
    public void softDeleteById(Long id) {
     multiChannelContentDao.softDeleteById(id);
    }

    @Override
    public void batchInsert(List<MultiChannelContentDTO> multiChannelContentDTOS) {
        if (CollUtil.isEmpty(multiChannelContentDTOS)) {
            return;
        }
        List<MultiChannelContent> multiChannelContents = new ArrayList<>();
        Map<MultiChannelContentDTO, MultiChannelContent> multiChannelContentMap = new HashMap<>();
        for (MultiChannelContentDTO multiChannelContentDTO : multiChannelContentDTOS) {
            MultiChannelContent multiChannelContent = BeanUtil.copyProperties(multiChannelContentDTO, MultiChannelContent.class);
            multiChannelContents.add(multiChannelContent);
            multiChannelContentMap.put(multiChannelContentDTO, multiChannelContent);
        }
        multiChannelContentDao.insert(multiChannelContents);
        List<MultiChannelContentItemDTO> multiChannelContentItemDTOS = new ArrayList<>();
        multiChannelContents.stream().forEach(e -> {
            if (CollUtil.isEmpty(e.getMultiChannelContentItems())) {
                return;
            }
            e.getMultiChannelContentItems().forEach(f -> f.setMultiChannelContentId(e.getId()));
            multiChannelContentItemDTOS.addAll(e.getMultiChannelContentItems());
        });
        if (CollUtil.isEmpty(multiChannelContentItemDTOS)) {
            return;
        }
        List<MultiChannelContentItem> multiChannelContentItems = BeanUtil.copyToList(multiChannelContentItemDTOS, MultiChannelContentItem.class);
        multiChannelContentItemBiz.insert(multiChannelContentItems);
        //复制id
        for (MultiChannelContentDTO e : multiChannelContentDTOS) {
               for(Map.Entry<MultiChannelContentDTO, MultiChannelContent> entry : multiChannelContentMap.entrySet()) {
                if (entry.getKey().equals(e)) {
                    e.setId(entry.getValue().getId());
                }
            }
           /* MultiChannelContent multiChannelContent = multiChannelContentMap.get(e);
            e.setId(null != multiChannelContent ? multiChannelContent.getId() : null);*/
        }
    }

    @Override
    public List<MultiChannelContentDTO> selectList(List<Long> multiChannelContentIds) {
        List<MultiChannelContentDTO> multiChannelContentDTOS = new ArrayList<>();
        if (CollUtil.isEmpty(multiChannelContentIds)) {
            return multiChannelContentDTOS;
        }
        List<MultiChannelContent> multiChannelContents = multiChannelContentDao.selectList(multiChannelContentIds);
        if  (CollUtil.isEmpty(multiChannelContents)) {
            return multiChannelContentDTOS;
        }
        List<Long> contentIds4Douyin = multiChannelContents.stream().filter(e -> ChannelTypeEnum.DOUYIN.code.equals(e.getChannelType())).map(f -> f.getId()).collect(Collectors.toList());
        List<Long> contentIds4Bili = multiChannelContents.stream().filter(e -> ChannelTypeEnum.BILI.code.equals(e.getChannelType())).map(f -> f.getId()).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(contentIds4Douyin)) {
            //填充抖音视频
            multiChannelContentDTOS = getMultiChannelContentDTOS4Douyin(multiChannelContentDTOS, multiChannelContents, contentIds4Douyin);
        }
        if (CollUtil.isNotEmpty(contentIds4Bili)) {
            //填充bili视频
            multiChannelContentDTOS = getMultiChannelContentDTOS4Bili(multiChannelContentDTOS, multiChannelContents, contentIds4Bili);
        }
        return multiChannelContentDTOS;
    }

    private List<MultiChannelContentDTO> getMultiChannelContentDTOS4Bili(List<MultiChannelContentDTO> multiChannelContentDTOS, List<MultiChannelContent> multiChannelContents, List<Long> contentIds4Bili) {
        //获取抖音视频
        List<MultiChannelContentItemDTO> multiChannelContentItemDTOS = multiChannelContentItemBiz.getByMultiChannelContentId(contentIds4Bili);
        List<MultiChannelContentDTO>  multiChannelContentDTOS4Bili = new ArrayList<>();
        if (CollUtil.isNotEmpty(multiChannelContentItemDTOS)) {
            multiChannelContentDTOS4Bili = BeanUtil.copyToList(multiChannelContents, MultiChannelContentDTO.class);
            List<String> itemIds = multiChannelContentItemDTOS.stream().map(e -> e.getItemId()).collect(Collectors.toList());
            Map<String, BiliVideoDTO> biliVideoDTOMap = channelConsr.getBiliVideoByItemIds(itemIds);
            multiChannelContentItemDTOS.stream().forEach(e -> {
                if (CollUtil.isNotEmpty(biliVideoDTOMap) || null != biliVideoDTOMap.get(e.getItemId())) {
                    BiliVideoDTO biliVideoDTO = biliVideoDTOMap.get(e.getItemId());
                    BeanUtil.copyProperties(biliVideoDTO, e, "id");
                }
            });
            Map<Long, List<MultiChannelContentItemDTO>> itemDTOMap = multiChannelContentItemDTOS.stream().collect(Collectors.groupingBy(MultiChannelContentItemDTO::getMultiChannelContentId));
            multiChannelContentDTOS4Bili.stream().forEach(e -> {
                List<MultiChannelContentItemDTO> multiChannelContentItems = CollUtil.isEmpty(e.getMultiChannelContentItems()) ? new ArrayList<>() : e.getMultiChannelContentItems();
                if (CollUtil.isNotEmpty(itemDTOMap.get(e.getId()))) {
                    multiChannelContentItems.addAll(itemDTOMap.get(e.getId()));
                    e.setMultiChannelContentItems(multiChannelContentItems);
                    multiChannelContentDTOS.add(e);
                }
            });
        }
        return multiChannelContentDTOS;
    }

    private List<MultiChannelContentDTO> getMultiChannelContentDTOS4Douyin(List<MultiChannelContentDTO> multiChannelContentDTOS, List<MultiChannelContent> multiChannelContents, List<Long> contentIds4Douyin) {
        //获取抖音视频
        List<MultiChannelContentItemDTO> multiChannelContentItemDTOS = multiChannelContentItemBiz.getByMultiChannelContentId(contentIds4Douyin);
        List<MultiChannelContentDTO> multiChannelContentDTOS4Douyin = new ArrayList<>();
        if ( CollUtil.isNotEmpty(multiChannelContentItemDTOS)) {
            multiChannelContentDTOS4Douyin = BeanUtil.copyToList(multiChannelContents, MultiChannelContentDTO.class);
            List<String> itemIds = multiChannelContentItemDTOS.stream().map(e -> e.getItemId()).collect(Collectors.toList());
            Map<String, DouyinVideoDTO> douyinVideoDTOMap = channelConsr.getDouyinVideoByItemIds(itemIds);
            multiChannelContentItemDTOS.stream().forEach(e -> {
                if (CollUtil.isNotEmpty(douyinVideoDTOMap) || null != douyinVideoDTOMap.get(e.getItemId())) {
                    DouyinVideoDTO douyinVideoDTO = douyinVideoDTOMap.get(e.getItemId());
                    BeanUtil.copyProperties(douyinVideoDTO, e, "id");
                }
            });
            Map<Long, List<MultiChannelContentItemDTO>> itemDTOMap = multiChannelContentItemDTOS.stream().collect(Collectors.groupingBy(MultiChannelContentItemDTO::getMultiChannelContentId));
            multiChannelContentDTOS4Douyin.stream().forEach(e -> {
                List<MultiChannelContentItemDTO> multiChannelContentItems = CollUtil.isEmpty(e.getMultiChannelContentItems()) ? new ArrayList<>() : e.getMultiChannelContentItems();
                if (CollUtil.isNotEmpty(itemDTOMap.get(e.getId()))) {
                    multiChannelContentItems.addAll(itemDTOMap.get(e.getId()));
                    e.setMultiChannelContentItems(multiChannelContentItems);
                    multiChannelContentDTOS.add(e);
                }
            });
        }
        return multiChannelContentDTOS;
    }
}
