package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.entity.ResourcePageBookstore;
import com.pcloud.book.group.dao.ResourcePageBookstoreDao;
import com.pcloud.book.group.vo.ResourcePageBookstoreVO;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 实体书购买(ResourcePageBookstore)表数据库访问层
 *
 * @author makejava
 * @since 2021-08-16 14:40:27
 */
@Repository("resourcePageBookstoreDaoImpl")
public class ResourcePageBookstoreDaoImpl extends BaseDaoImpl<ResourcePageBookstore> implements ResourcePageBookstoreDao {

    @Override
    public Integer deleteByResourcePageId(Long resourcePageId, Integer fixtureType) {
        Map<String, Object> params = new HashMap<>();
        params.put("resourcePageId", resourcePageId);
        params.put("fixtureType", fixtureType);
        return super.sqlSessionTemplate.delete(getStatement("deleteByResourcePageId"), params);
    }

    @Override
    public List<ResourcePageBookstoreVO> getByResourcePageId(Long resourcePageId, Integer fixtureType) {
        Map<String, Object> params = new HashMap<>();
        params.put("resourcePageId", resourcePageId);
        params.put("fixtureType", fixtureType);
        return super.sqlSessionTemplate.selectList(getStatement("getByResourcePageId"), params);
    }
}
