package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.ResourcePageNavigationDao;
import com.pcloud.book.group.entity.ResourcePageNavigation;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName com.pcloud.book.group.dao.impl.ResourcePageNavigationDaoImpl
 * @Author zhuyajie
 * @Description 资源页导航
 * @Date 2021/8/16 10:45
 * @Version 1.0
 **/
@Component
public class ResourcePageNavigationDaoImpl extends BaseDaoImpl<ResourcePageNavigation> implements ResourcePageNavigationDao {
    @Override
    public List<ResourcePageNavigation> getByPageId(Long resourcePageId) {
        return getSessionTemplate().selectList(getStatement("getByPageId"), resourcePageId);
    }

    @Override
    public List<Long> getNoNavigationPages(Integer openRays) {
        Map<String, Object> map = new HashMap<>();
        map.put("openRays", openRays);
        return getSessionTemplate().selectList(getStatement("getNoNavigationPages"), map);
    }

    @Override
    public ResourcePageNavigation getByType(Long resourcePageId, Integer type) {
        Map<String, Object> map = new HashMap<>();
        map.put("resourcePageId", resourcePageId);
        map.put("navigationType", type);
        return getSessionTemplate().selectOne(getStatement("getByType"), map);
    }

    @Override
    public Integer getMaxSeq(Long resourcePageId) {
        return getSessionTemplate().selectOne(getStatement("getMaxSeq"), resourcePageId);
    }

    @Override
    public void deleteNavigation(Long resourcePageId, Integer type) {
        Map<String, Object> map = new HashMap<>();
        map.put("resourcePageId", resourcePageId);
        map.put("navigationType", type);
        getSessionTemplate().delete(getStatement("deleteNavigation"), map);
    }

    @Override
    public ResourcePageNavigation getByName(Long resourcePageId, String navigationName) {
        Map<String, Object> map = new HashMap<>();
        map.put("resourcePageId", resourcePageId);
        map.put("navigationName", navigationName.trim());
        return getSessionTemplate().selectOne(getStatement("getByName"), map);
    }

    @Override
    public void updateSeq4Batch(List<ResourcePageNavigation> list) {
        getSessionTemplate().update(getStatement("updateSeq4Batch"), list);
    }

    @Override
    public ResourcePageNavigation getNavigationByMoveType(String moveType, Long resourcePageId, Integer navigationSeq) {
        Map<String, Object> map = new HashMap<>();
        map.put("resourcePageId", resourcePageId);
        map.put("moveType", moveType);
        map.put("navigationSeq", navigationSeq);
        return getSessionTemplate().selectOne(getStatement("getNavigationByMoveType"), map);
    }

    @Override
    public void updateNavigationSeqNum(Long navigationId, Integer navigationSeq) {
        Map<String, Object> map = new HashMap<>();
        map.put("id", navigationId);
        map.put("navigationSeq", navigationSeq);
        getSessionTemplate().update(getStatement("updateNavigationSeqNum"), map);
    }

    @Override
    public Integer countByPageId(Long resourcePageId) {
        Map<String, Object> map = new HashMap<>();
        map.put("resourcePageId", resourcePageId);
        return getSessionTemplate().selectOne(getStatement("countByPageId"), map);
    }
}
