package com.pcloud.book.group.vo;

import com.pcloud.book.group.dto.WxworkPageFixedDTO;
import com.pcloud.common.dto.BaseDto;

import lombok.Data;

import java.util.Map;

/**
 * @ClassName com.pcloud.book.group.vo.WxworkPageVO
 * @Author zhuyajie
 * @Description 企业微信落地页
 * @Date 2021/12/2 14:37
 **/
@Data
public class WxworkPageVO extends BaseDto {
    /**
     * 资源页id
     */
    private Long resourcePageId;
    /**
     * 模板类型1自定义2固定3模板其他
     */
    private Integer templateType;
    /**
     * 是否展示图书信息1是0否
     */
    private Integer displayBook;
    /**
     * 引导语
     */
    private String guide;
    /**
     * 二维码类型（1企微个人码2企微群码3crm个人码4crm群码）
     */
    private Integer qrcodeType;
    /**
     * 二维码id
     */
    private Long qrcodeId;
    /**
     * 二维码名称
     */
    private String qrcodeName;
    /**
     * 二维码url
     */
    private String qrcodeUrl;
    /**
     * 自定义背景图
     */
    private String basePic;
    /**
     * 自定义：二维码位置上方间距百分比
     */
    private Integer topSpace;
    /**
     * 自定义：二维码位置左边间距百分比
     */
    private Integer leftSpace;
    /**
     * html生成图
     */
    private String htmlPic;
    /**
     * 其他模板参数
     */
    private WxworkPageFixedDTO fixedDTO;
    /**
     * 创建人
     */
    private Long createUser;
    /**
     * 图片高度
     */
    private Integer height;

    /**
     * 存储落地页 - 自定义类型的前端配置
     */
    private Map<String,Object> config;

    /**
     * 是否旧模板 - 旧数据标识
     */
    private Boolean oldTemplate;
}
