/**
 * 
 */
package com.pcloud.book.mq.topic;

import com.pcloud.book.group.biz.ResourcePageBiz;
import com.pcloud.book.mq.config.MQTopicConumer;
import com.pcloud.channelcenter.qrcode.entity.QrcodeScene;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.data.domain.enums.YesNoEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 二维码删除
 */
@Component
@RabbitListener(queues = MQTopicConumer.DELETE_QRCODE)
public class DeleteQrcodeListener {

	/**
	 * 
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(DeleteQrcodeListener.class);

	@Autowired
	private ResourcePageBiz resourcePageBiz;

	/**
	 * 二维码删除
	 */
	@RabbitHandler
	public void process(QrcodeScene qrcodeScene) {
		if (null == qrcodeScene || null == qrcodeScene.getSceneId()) {
			return;
		}
		try {
			resourcePageBiz.updateDeleteBySceneId(qrcodeScene.getSceneId(), YesNoEnum.YES.value);
		} catch (Exception e) {
			LOGGER.error("【二维码删除】消费topic,JMS异常,<ERROR>:" + e.getMessage(), e);
		}
	}
}
