package com.pcloud.book.timecontrol.dto;

import lombok.Builder;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @date: 2020年01月30日 14:08
 * @Author: Zcy
 * @Descprition 时间管理任务模板创建
 */
@Builder
@Data
public class CreateTaskDto implements Serializable {

    @NotNull(message = "任务名称不能为空")
    @Size(max = 20)
    private String taskName;
    @Size(max = 300)
    @NotNull(message = "任务引导语不能为空")
    private String taskIntroduce;
    @Size(max = 20)
    @NotNull(message = "订阅方式不能为空")
    private String subscribeWord;

    private Integer advancedSetting;

    private Integer sendType;

    private Long depLabelId;

    private Long purLabelId;

    private Long proLabelId;



}
