package com.pcloud.book.applet.biz;

import com.pcloud.book.applet.dto.AppletNewsClassifyDTO;
import com.pcloud.book.applet.dto.AppletNewsCommentDTO;
import com.pcloud.book.applet.dto.AppletNewsDTO;
import com.pcloud.book.applet.entity.AppletNews;
import com.pcloud.book.applet.entity.AppletNewsClassify;
import com.pcloud.book.applet.entity.AppletNewsComment;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;

/**
 * 小程序资讯
 */
public interface AppletNewsBiz {

    /**
     * 新增资讯分类
     * @param appletNewsClassify
     * @return
     */
    Long addAppletNewsClassify(AppletNewsClassify appletNewsClassify);

    /**
     * 修改资讯分类
     * @param appletNewsClassify
     */
    void updateAppletNewsClassify(AppletNewsClassify appletNewsClassify);

    /**
     * 删除资讯分类
     * @param id
     */
    void deleteNewsClassifyById(Long id);

    /**
     * 资讯栏目列表
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<AppletNewsClassifyDTO> listNewsClassify(Integer currentPage, Integer numPerPage, String name);

    /**
     * 添加资讯
     * @param appletNews
     * @return
     */
    Long addAppletNews(AppletNews appletNews);

    /**
     * 修改资讯
     * @param appletNews
     */
    void updateAppletNews(AppletNews appletNews);

    /**
     * 删除资讯
     * @param id
     */
    void deleteAppletNewsById(Long id);

    /**
     * 资讯列表
     * @param currentPage
     * @param numPerPage
     * @param name
     * @return
     */
    PageBeanNew<AppletNewsDTO> listAppletNews(Integer currentPage, Integer numPerPage, String name,
                                             Long firstClassify,Long secondClassify,Long gradeLabelId,
                                              Long subjectLabelId,Long rightsClassifyId);

    /**
     * 获取所有资讯栏目
     * @return
     */
    List<AppletNewsClassifyDTO> getAllNewsClassify(Boolean showState);

    /**
     * 客户端资讯列表
     * @param currentPage
     * @param numPerPage
     * @param newsClassifyId
     * @return
     */
    PageBeanNew<AppletNewsDTO> listAppletNews4Wechat(Integer currentPage, Integer numPerPage, Long newsClassifyId);

    /**
     * 添加资讯评论
     * @param appletNewsComment
     */
    void addAppletNewsComment(AppletNewsComment appletNewsComment, Long wechatUserId);

    /**
     * 查询资讯评论
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<AppletNewsCommentDTO> listNewsCommentByNewsId(Integer currentPage, Integer numPerPage, Long newsId);

    /**
     * 根据id查资讯详情
     * @param id
     * @return
     */
    AppletNewsDTO getNewsById(Long id);

    /**
     * 更新上架状态
     * @param appletNews
     */
    void updateNewsShowState(AppletNews appletNews);

    /**
     * 根据书刊分类标签权益分类查询
     * @param firstClassify
     * @param secondClassify
     * @param gradeLabelId
     * @param subjectLabelId
     * @param rightsType
     * @return
     */
    List<AppletNewsDTO> getNewsByTempletLabel(Long firstClassify, Long secondClassify, Long gradeLabelId, Long subjectLabelId, String rightsType);
}
