package com.pcloud.book.applet.dao;

import com.pcloud.book.applet.dto.AppletNewsDTO;
import com.pcloud.book.applet.entity.AppletNews;
import com.pcloud.common.core.dao.BaseDao;
import java.util.List;


/**
 * 小程序资讯
 */
public interface AppletNewsDao extends BaseDao<AppletNews> {


    /**
     * 根据分类查询
     * @param newsClassifyId
     * @return
     */
    List<AppletNews> getByNewsClassifyId(Long newsClassifyId);

    /**
     * 更新上架状态
     * @param appletNews
     */
    void updateNewsShowState(AppletNews appletNews);

    /**
     * 根据分类标签查资讯
     * @param firstClassify
     * @param secondClassify
     * @param gradeLabelId
     * @param subjectLabelId
     * @param rightsType
     * @return
     */
    List<AppletNewsDTO> getByNewsByTempletLabel(Long firstClassify, Long secondClassify, Long gradeLabelId, Long subjectLabelId, String rightsType);

    List<AppletNews> getByTempletAndClassify(Long firstClassify, Long secondClassify, Long gradeLabelId, Long subjectLabelId, Long rightsClassifyId, Integer top);
}
