package com.pcloud.book.book.vo.request;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.book.constant.BookConstant;
import com.pcloud.book.book.entity.KeywordWarehouse;
import com.pcloud.book.book.entity.KeywordWarehouseDetail;
import com.pcloud.book.book.vo.BookKeywordDetailVO;
import com.pcloud.book.book.vo.KeywordWearhouseLabelVO;
import com.pcloud.common.entity.BaseRequestVO;
import com.pcloud.common.utils.BeanUtils;
import com.pcloud.common.utils.string.StringUtil;

import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;
import java.util.Map;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@EqualsAndHashCode(callSuper = true)
@Data
@ToString(callSuper = true)
@ApiModel
public class EditBookKeywordRequestVO extends BaseRequestVO {
    private static final long serialVersionUID = 719494003873772831L;

    @ApiModelProperty("关键词主键")
    private Long keywordId;

    @ApiModelProperty("关键词")
    private String keyword;

    @ApiModelProperty("引导语")
    private String guide;

    @ApiModelProperty("匹配规则（0：精准匹配1：模糊匹配）")
    private Integer matchingRule;

    @ApiModelProperty("适用范围（0：所有出版社,1：编辑）")
    private Integer scope;

    @ApiModelProperty("编辑id（适用范围为所有出版社的时候可以为空）")
    private Long editorId;

    @ApiModelProperty("关键词详情")
    private List<BookKeywordDetailVO> details;

    public KeywordWarehouse getEntity() {
        final KeywordWarehouse warehouse = new KeywordWarehouse();
        BeanUtils.copyProperties(this, warehouse);
        final Date now = new Date();
        warehouse.setId(keywordId);
        warehouse.setAuditStatus(BookConstant.BookKeywordAuditEnum.NORMAL.getCode());
        warehouse.setUpdateUser(this.getUserId());
        warehouse.setUpdateTime(now);
        return warehouse;
    }

    public List<KeywordWarehouseDetail> getDetailEntity(Long keywordId) {
        final List<KeywordWarehouseDetail> list = Lists.newArrayList();
        List<BookKeywordDetailVO> details = this.getDetails();
        Map<Integer, String> map = Maps.newHashMap();
        for (BookKeywordDetailVO vo : details) {
            final List<KeywordWearhouseLabelVO> labels = vo.getLabels();
            if("PRODUCT".equals(vo.getProductType()) && null == vo.getChannelId()) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "渠道信息不能为空");
            }
            if(CollectionUtils.isEmpty(labels)) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "标签信息为空");
            }
            for (KeywordWearhouseLabelVO labelVO : vo.getLabels()) {
                final KeywordWarehouseDetail detail = new KeywordWarehouseDetail();
                BeanUtils.copyProperties(vo, detail);
                String uuid = map.get(vo.getGroupId());
                if (StringUtil.isBlank(uuid)) {
                    uuid = StringUtil.getUUID();
                    map.put(vo.getGroupId(), uuid);
                }
                // 分组id唯一
                detail.setGroupId(uuid);
                detail.setPurposeLabelId(labelVO.getPurposeLabelId());
                detail.setDepthLabelId(labelVO.getDepthLabelId());
                detail.setProfessionalLabelId(labelVO.getProfessionalLabelId());
                final Date now = new Date();
                detail.setUseNum(0);
                detail.setKeywordId(keywordId);
                detail.setCreateUser(this.getUserId());
                detail.setUpdateUser(this.getUserId());
                detail.setCreateTime(now);
                detail.setUpdateTime(now);
                detail.setIsDelete(0);
                list.add(detail);
            }
        }
        return list;
    }

    public Boolean check() {
        return null == this.getKeywordId()
                || StringUtil.isBlank(this.getKeyword())
                || StringUtil.isBlank(this.getGuide())
                || null == this.getMatchingRule()
                || null == this.getScope()
                || null == this.getUserId()
                || CollectionUtils.isEmpty(this.getDetails())
                || (scope != 0 && null == this.getEditorId())
                ;
    }


}
