package com.pcloud.book.cultivate.service.impl;

import com.pcloud.book.cultivate.dao.CultivateNotifySendDao;
import com.pcloud.book.cultivate.entity.CultivateNotifySend;
import com.pcloud.book.cultivate.service.CultivateNotifyService;
import com.pcloud.book.timecontrol.biz.TaskBiz;
import com.pcloud.book.timecontrol.biz.TaskSubscribeBiz;
import com.pcloud.book.timecontrol.dto.BookTaskBindingDto;
import com.pcloud.book.timecontrol.dto.LabelDto;
import com.pcloud.book.timecontrol.dto.TaskDto;
import com.pcloud.book.timecontrol.mapper.TimeControlTaskMapper;
import com.pcloud.book.timecontrol.service.TimeControlTaskService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;


@RestController("cultivateNotifyService")
@RequestMapping("cultivateNotifyService")
public class CultivateNotifyServiceImpl implements CultivateNotifyService {

    @Autowired
    private CultivateNotifySendDao cultivateNotifySendDao;

    @Override
    @RequestMapping(value = "/batchSendMiniUser", method = RequestMethod.POST)
    public void batchSendMiniUser(@RequestBody List<CultivateNotifySend> list) throws BizException {
          if(!ListUtils.isEmpty(list)){
              cultivateNotifySendDao.insert(list);
          }
    }
}
