package com.pcloud.book.giftcoupon.check;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.giftcoupon.entity.GiftCouponPackage;
import com.pcloud.book.giftcoupon.entity.GiftReceive;
import com.pcloud.common.utils.DateUtils;
import com.pcloud.common.utils.string.StringUtil;

import org.springframework.stereotype.Component;

import java.util.Date;

import lombok.extern.slf4j.Slf4j;

@Component("giftParamCheck")
@Slf4j
public class GiftParamCheck {

    public void checkGiftAddParam(GiftCouponPackage giftCouponPackage) {
        if (null == giftCouponPackage) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "参数为空");
        }
        if (StringUtil.isEmpty(giftCouponPackage.getTitle())) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "名称为空");
        }
        if (giftCouponPackage.getTitle().length()>20) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "标题名称最多20个字");
        }
        if (null == giftCouponPackage.getDenomination()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "面额为空");
        }
        if (giftCouponPackage.getDenomination()>999) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "面额最多999");
        }
        if (null == giftCouponPackage.getStock()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "库存为空");
        }
        if (giftCouponPackage.getStock()>99999) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "库存最多99999");
        }
        if (null == giftCouponPackage.getReceiveLimit()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "领取上限为空");
        }
        if (giftCouponPackage.getReceiveLimit()>5) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "领取上限最多5张");
        }
        if (null == giftCouponPackage.getValidDateBegin() || null==giftCouponPackage.getValidDateEnd()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "有效期为空");
        }
        if (DateUtils.getDateByStr(giftCouponPackage.getValidDateBegin()).after(DateUtils.getDateByStr((giftCouponPackage.getValidDateEnd())))) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "有效期开始时间不能大于结束时间");
        }
        if (DateUtils.getDateByStr(giftCouponPackage.getValidDateEnd()).before(new Date())) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "有效期结束时间不能小于当前时间");
        }
    }

    public void checkGiftReceiveAddParam(GiftReceive giftReceive) {
        if (null == giftReceive) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "参数为空");
        }
        if (null==giftReceive.getWechatUserId()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "用户为空");
        }
        if (null==giftReceive.getGiftPackageId()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "奖券包id为空");
        }
    }
}
