package com.pcloud.book.pcloudkeyword.biz.impl;

import com.pcloud.book.pcloudkeyword.biz.PcloudKeywordBiz;
import com.pcloud.book.pcloudkeyword.biz.PcloudKeywordClassifyBiz;
import com.pcloud.book.pcloudkeyword.dao.PcloudKeywordClassifyDao;
import com.pcloud.book.pcloudkeyword.dao.PcloudRobotClassifyDao;
import com.pcloud.book.pcloudkeyword.dto.PcloudKeywordClassifyDTO;
import com.pcloud.book.pcloudkeyword.entity.PcloudKeywordClassify;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobotClassify;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.ListUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("pcloudKeywordClassifyBiz")
public class PcloudKeywordClassifyBizImpl implements PcloudKeywordClassifyBiz {

    @Autowired
    private PcloudKeywordClassifyDao pcloudKeywordClassifyDao;
    @Autowired
    private PcloudKeywordBiz pcloudKeywordBiz;
    @Autowired
    private PcloudRobotClassifyDao pcloudRobotClassifyDao;

    @Override
    public Long insert(PcloudKeywordClassify pcloudKeywordClassify) {
        pcloudKeywordClassifyDao.insert(pcloudKeywordClassify);
        Long id = pcloudKeywordClassify.getId();
        return id;
    }

    @Override
    public void update(PcloudKeywordClassify pcloudKeywordClassify) {
        pcloudKeywordClassifyDao.update(pcloudKeywordClassify);
    }

    @Override
    public void deleteById(Long id) {
        pcloudKeywordClassifyDao.setDeleteById(id);
        //删除关键词
        pcloudKeywordBiz.deleteByKeywordClassifyId(id);
    }

    @Override
    public void updateOpenStateById(Long id, Boolean open) {
        pcloudKeywordClassifyDao.updateOpenById(id, open);
    }

    @Override
    public List<PcloudKeywordClassifyDTO> list(String classify){
        List<PcloudKeywordClassifyDTO> list = pcloudKeywordClassifyDao.list(classify);
        return list;
    }

    @Override
    public PcloudKeywordClassify getKeywordClassifyByRobotClassifyId(Long robotClassifyId) {
        PcloudRobotClassify robotClassify = pcloudRobotClassifyDao.getById(robotClassifyId);
        if (robotClassify==null||robotClassify.getKeywordClassifyId()==null){
            return new PcloudKeywordClassify();
        }
        Long pcloudClassifyId=robotClassify.getKeywordClassifyId();
        //查询该小号对应小号分类的关键词分类
        PcloudKeywordClassify pcloudKeywordClassify = pcloudKeywordClassifyDao.getById(pcloudClassifyId);
        return pcloudKeywordClassify;
    }
}
