package com.pcloud.book.rightsSetting.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @ClassName com.pcloud.book.rightsSetting.entity.RightsItemGroup
 * @Author ruansiyuan
 * @Description 权益配套资料分组
 * @Date 2020/4/26 16:22
 * @Version 1.0
 **/
@ApiModel("权益配套资料分组")
@Data
public class RightsItemGroup extends BaseEntity {

    @ApiModelProperty("权益id")
    private Long rightsSettingId;

    @ApiModelProperty("分组名称")
    private String name;

    @ApiModelProperty("是否展示")
    private Boolean showState;

    @ApiModelProperty("类型：1本书原版资料，2自定义")
    private Integer type;

    @ApiModelProperty("图片")
    private String pic;

    @ApiModelProperty("描述1")
    private String desc1;

    @ApiModelProperty("描述2")
    private String desc2;

    @ApiModelProperty("描述3")
    private String desc3;

    @ApiModelProperty("描述集合")
    private List<String> descList;

    @ApiModelProperty("应用或作品集合")
    private List<RightsNowItem> rightsNowItems;

}