package com.pcloud.book.book.entity;

import com.pcloud.common.entity.BaseEntity;

import java.math.BigDecimal;

/**
 * @描述：书刊基金实体
 * @作者：李浩
 * @创建时间：2016年7月14日,下午2:30:06
 * @版本：1.0
 */
public class BookFund extends BaseEntity {

    /**
     * 序列号
     */
    private static final long serialVersionUID = -3925563363953434473L;

    /**
     * 书刊基金标识
     */
    private Long bookFundId;

    /**
     * 书刊标识
     */
    private Long bookId;

    /**
     * 基金名称
     */
    private String fundName;

    /**
     * 购买金额
     */
    private BigDecimal purchaseMoney;

    /**
     * 开始时间
     */
    private String startTime;

    /**
     * 结束时间
     */
    private String endTime;

    /**
     * 创建人
     */
    private Long createdUser;

    /**
     * 最后修改人
     */
    private Long lastModifiedUser;

    /**
     * 是否代理模式-新增于2018-8-6
     */
    private Integer proxyMode;
    /**
     * 转让方-新增于2018-8-6
     */
    private String transferor;

    /**
     * 挂牌/合同编号
     */
    private String contractNo;
    /**
     * 批次号
     */
    private String batchNumber;
    /**
     * 是否为受让方
     */
    private Integer isTransferor;

    public Integer getIsTransferor() {
        return isTransferor;
    }

    public void setIsTransferor(Integer isTransferor) {
        this.isTransferor = isTransferor;
    }

    public Integer getProxyMode() {
        return proxyMode;
    }

    public void setProxyMode(Integer proxyMode) {
        this.proxyMode = proxyMode;
    }

    public String getTransferor() {
        return transferor;
    }

    public void setTransferor(String transferor) {
        this.transferor = transferor;
    }

    public Long getBookFundId() {
        return bookFundId;
    }

    public void setBookFundId(Long bookFundId) {
        this.bookFundId = bookFundId;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public String getFundName() {
        return fundName;
    }

    public void setFundName(String fundName) {
        this.fundName = fundName;
    }

    public BigDecimal getPurchaseMoney() {
        return purchaseMoney;
    }

    public void setPurchaseMoney(BigDecimal purchaseMoney) {
        this.purchaseMoney = purchaseMoney;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Long getCreatedUser() {
        return createdUser;
    }

    public void setCreatedUser(Long createdUser) {
        this.createdUser = createdUser;
    }

    public Long getLastModifiedUser() {
        return lastModifiedUser;
    }

    public void setLastModifiedUser(Long lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    public String getContractNo() {
        return contractNo;
    }

    public void setContractNo(String contractNo) {
        this.contractNo = contractNo;
    }

    public String getBatchNumber() {
        return batchNumber;
    }

    public void setBatchNumber(String batchNumber) {
        this.batchNumber = batchNumber;
    }

    @Override
    public String toString() {
        return "BookFund [bookFundId=" + bookFundId + ", bookId=" + bookId + ", fundName=" + fundName
                + ", purchaseMoney=" + purchaseMoney + ", startTime=" + startTime + ", endTime=" + endTime
                + ", createdUser=" + createdUser + ", lastModifiedUser=" + lastModifiedUser + "]";
    }
}
