package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.BookGroupClassifyDao;
import com.pcloud.book.group.dto.BookClassifyDTO;
import com.pcloud.book.group.dto.BookGroupStatisticDTO;
import com.pcloud.book.group.dto.ClassifyDTO;
import com.pcloud.book.group.dto.ClassifyKeywordDTO;
import com.pcloud.book.group.dto.ClickClassifyDTO;
import com.pcloud.book.group.dto.GroupClassifyQrcodeDTO;
import com.pcloud.book.group.dto.GroupNameAndMaxSeqDTO;
import com.pcloud.book.group.dto.GroupQrcodeBaseDTO;
import com.pcloud.book.group.dto.ProAssocGroupAndUserNumberDTO;
import com.pcloud.book.group.entity.BookGroupClassify;
import com.pcloud.book.group.vo.BookGroupQrcodeStatisticVO;
import com.pcloud.book.group.vo.ClassifyNameVO;
import com.pcloud.book.group.vo.ClassifyVO;
import com.pcloud.book.group.vo.GroupQrcode4ClassifyVO;
import com.pcloud.book.group.vo.ListClassify4WechatVO;
import com.pcloud.book.group.vo.ListClassifyVO;
import com.pcloud.book.group.vo.StatisticVO;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2019/4/17 11:21
 */
@Component("bookGroupClassifyDao")
public class BookGroupClassifyDaoImpl extends BaseDaoImpl<BookGroupClassify> implements BookGroupClassifyDao {
    @Override
    public Boolean isHaveThisClassify(String classify, Long classifyId, Long bookGroupId) {
        Map<String, Object> paramMap = new HashMap();
        paramMap.put("classify", classify);
        paramMap.put("bookGroupId", bookGroupId);
        paramMap.put("classifyId", classifyId);
        return this.getSqlSession().selectOne(this.getStatement("isHaveThisClassify"), paramMap);
    }

    @Override
    public ClassifyVO getClassify(Long classifyId) {
        return this.getSqlSession().selectOne(this.getStatement("getClassify"), classifyId);
    }

    @Override
    public ClassifyDTO getById(Long classifyId) {
        return this.getSqlSession().selectOne(this.getStatement("getById"), classifyId);
    }

    @Override
    public void updateSpecId(Long id, Long productSpecId) {
        Map<String, Object> paramMap = new HashMap();
        paramMap.put("id", id);
        paramMap.put("productSpecId", productSpecId);
        this.getSqlSession().update(this.getStatement("updateSpecId"), paramMap);
    }

    @Override
    public void deleteClassify(Long classifyId, Long partyId) {
        Map<String, Object> paramMap = new HashMap();
        paramMap.put("classifyId", classifyId);
        paramMap.put("partyId", partyId);
        this.getSqlSession().update(this.getStatement("deleteClassify"), paramMap);
    }

    @Override
    public Integer getClassifyCount(Long bookGroupId) {
        return this.getSqlSession().selectOne(this.getStatement("getClassifyCount"), bookGroupId);
    }

    @Override
    public List<BookGroupClassify> getClassifyByIds(List<Long> weixinGroupClassifyPrimaryIds) {
        return this.getSqlSession().selectList(this.getStatement("getClassifyByIds"), weixinGroupClassifyPrimaryIds);
    }
    @Override
    public List<ListClassifyVO> listAllClassifyByRank(Long bookGroupId) {
        return this.getSqlSession().selectList(this.getStatement("listAllClassifyByRank"), bookGroupId);
    }

    @Override
    public List<ListClassifyVO> listAllClassifyByUser(Long bookGroupId) {
        return this.getSqlSession().selectList(this.getStatement("listAllClassifyByUser"), bookGroupId);
    }

    @Override
    public void updateClassifyRank(BookGroupClassify bookGroupClassify) {
        this.getSqlSession().update(this.getStatement("updateClassifyRank"), bookGroupClassify);
    }

    @Override
    public List<ClassifyNameVO> listClassifyByRank(Long bookGroupId) {
        return this.getSqlSession().selectList(this.getStatement("listClassifyByRank"), bookGroupId);
    }

    @Override
    public List<ClassifyNameVO> listClassifyByUser(Long bookGroupId) {
        return this.getSqlSession().selectList(this.getStatement("listClassifyByUser"), bookGroupId);
    }

    @Override
    public Integer getGroupCount(Long bookGroupId) {
        return this.getSqlSession().selectOne(this.getStatement("getGroupCount"), bookGroupId);
    }

    @Override
    public Integer getUserNumberCount(Long bookGroupId) {
        return this.getSqlSession().selectOne(this.getStatement("getUserNumberCount"), bookGroupId);
    }

    @Override
    public GroupNameAndMaxSeqDTO getGroupNameAndMaxSeq(Long classifyId) {
        return this.getSqlSession().selectOne(this.getStatement("getGroupNameAndMaxSeq"), classifyId);
    }

    @Override
    public GroupClassifyQrcodeDTO getClassifyQrcodeInfo(String weixinGroupId) {
        return this.getSqlSession().selectOne(this.getStatement("getClassifyQrcodeInfo"), weixinGroupId);
    }

    @Override
    public List<GroupClassifyQrcodeDTO> listClassifyQrcodeInfo(List<Long> classifyIds) {
        return this.getSqlSession().selectList(this.getStatement("listClassifyQrcodeInfo"), classifyIds);
    }

    @Override
    public List<ListClassify4WechatVO> listClassify4Wechat(Long bookGroupId, Integer rankType) {
        Map<String, Object> paramMap = new HashMap();
        paramMap.put("bookGroupId", bookGroupId);
        paramMap.put("rankType", rankType);
        return this.getSqlSession().selectList(this.getStatement("listClassify4Wechat"), paramMap);
    }

    @Override
    public GroupQrcode4ClassifyVO getClassifyQrcode(Long classifyId, Integer changeNumber) {
        Map<String, Object> paramMap = new HashMap();
        paramMap.put("classifyId", classifyId);
        paramMap.put("changeNumber", changeNumber);
        return this.getSqlSession().selectOne(this.getStatement("getClassifyQrcode"), paramMap);
    }

    @Override
    public Map<Long, BookGroupStatisticDTO> getBookGroupStatistic(List<Long> bookGroupIds) {
        return this.getSqlSession().selectMap(this.getStatement("getBookGroupStatistic"), bookGroupIds, "bookGroupId");
    }

    @Override
    public List<BookGroupQrcodeStatisticVO> listBookGroupQrcodeStatistic(List<Long> classifyIds, Long bookGroupId) {
        Map<String, Object> paramMap = new HashMap();
        paramMap.put("classifyIds", classifyIds);
        paramMap.put("bookGroupId", bookGroupId);
        return this.getSqlSession().selectList(this.getStatement("listBookGroupQrcodeStatistic"), paramMap);
    }

    @Override
    public StatisticVO getStatistic4Adviser(Long adviserId) {
        return this.getSqlSession().selectOne(this.getStatement("getStatistic4Adviser"), adviserId);
    }

    @Override
    public Map<String, GroupQrcodeBaseDTO> listGroupQrcodeBaseInfo(List<String> weixinGroupIds) {
        return this.getSqlSession().selectMap(this.getStatement("listGroupQrcodeBaseInfo"), weixinGroupIds, "weixinGroupId");
    }

    @Override
    public ProAssocGroupAndUserNumberDTO getProAssocGroupAndUserNumber(Long productId) {
        return this.getSqlSession().selectOne(this.getStatement("getProAssocGroupAndUserNumber"), productId);
    }

    @Override
    public Integer getMaxRank(Long bookGroupId) {
        return this.getSqlSession().selectOne(this.getStatement("getMaxRank"), bookGroupId);
    }

    @Override
    public ClassifyDTO getBaseInfoBySpecId(Long productSpecId) {
        return this.getSqlSession().selectOne(this.getStatement("getBaseInfoBySpecId"), productSpecId);
    }

    @Override
    public List<ClassifyDTO> getNameWithBookNameByIds(List<Long> classifyIds) {
        return this.getSqlSession().selectList(this.getStatement("getNameWithBookNameByIds"), classifyIds);
    }

    @Override
    public List<Long> getIdByBookGroupIds(List<Long> bookGroupIdList) {
        return this.getSqlSession().selectList(this.getStatement("getIdByBookGroupIds"), bookGroupIdList);
    }

    @Override
    public Map<Long,List<Long>> getClassifyIdsByBookGroupIds(List<Long> bookGroupIdList) {
        return this.getSqlSession().selectMap(this.getStatement("getClassifyIdsByBookGroupIds"), bookGroupIdList,"bookGroupId");
    }

    @Override
    public List<ClassifyDTO> getNameWithBookClockInfoIdByIds(Map<String,Object> paramMap) {
        return this.getSqlSession().selectList(this.getStatement("getNameWithBookClockInfoIdByIds"), paramMap);
    }

    @Override
    public StatisticVO getBookGroupStatistics(Long bookId) {
        return this.getSqlSession().selectOne(this.getStatement("getBookGroupStatistics"), bookId);
    }

    @Override
    public List<ClassifyKeywordDTO> getClassifyStatistics(Long bookId) {
        return this.getSqlSession().selectList(this.getStatement("getClassifyStatistics"), bookId);
    }
	
	@Override
    public Map<Long, BookClassifyDTO> getGroupClassifyCount(List<Long> bookIds) {
        return this.getSessionTemplate().selectMap(getStatement("getGroupClassifyCount"), bookIds,"bookId");
    }

    @Override
    public GroupClassifyQrcodeDTO getClassifyQrcodeInfoByName(String weixinGroupName) {
        return this.getSessionTemplate().selectOne(getStatement("getClassifyQrcodeInfoByName"), weixinGroupName);
    }
    @Override
    public void updateHasOpenLearningReport(Long classifyId, Boolean hasOpenLearningReport, Long partyId) {
        Map<String, Object> paramMap = new HashMap();
        paramMap.put("classifyId", classifyId);
        paramMap.put("hasOpenLearningReport", hasOpenLearningReport);
        paramMap.put("partyId", partyId);
        this.getSqlSession().update(this.getStatement("updateHasOpenLearningReport"), paramMap);

    }

    @Override
    public void dragSortClassify(List<Long> classifyIds) {
        Map<String, Object> paramMap = new HashMap();
        paramMap.put("classifyIds", classifyIds);
        this.getSqlSession().update(this.getStatement("dragSortClassify"), paramMap);
    }

    @Override
    public void addClickClassify(Long wechatUserId, Long bookGroupId, Long classifyId) {
        Map<String, Object> paramMap = new HashMap();
        paramMap.put("classifyId", classifyId);
        paramMap.put("wechatUserId", wechatUserId);
        paramMap.put("bookGroupId", bookGroupId);
        this.getSqlSession().insert(this.getStatement("addClickClassify"), paramMap);
    }

    @Override
    public Map<Long, ClickClassifyDTO> mapClickClassify(List<Long> classifyIds) {
        Map<String, Object> paramMap = new HashMap();
        paramMap.put("classifyIds", classifyIds);
        return this.getSqlSession().selectMap(this.getStatement("mapClickClassify"), paramMap,"classifyId");
    }

    @Override
    public List<ListClassifyVO> getClassifyIngoreDelete(Long bookGroupId) {
        return this.getSqlSession().selectList(this.getStatement("getClassifyIngoreDelete"), bookGroupId);
    }

    @Override
    public List<BookGroupClassify> getListByBookGroupId(Long bookGroupId) {
        return this.getSqlSession().selectList(this.getStatement("getListByBookGroupId"), bookGroupId);
    }

}
