package com.pcloud.book.appeal.dto;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.book.dto.BookDto;
import com.pcloud.book.book.entity.BookDefendant;
import com.pcloud.common.entity.BaseEntity;

/**
 * 期刊申诉
 * @author:lili
 * @date 创建时间：2017年3月30日 下午3:22:42
 * @version 1.0
 * @return
 */
public class BookAppealDto extends BaseEntity{
	/**
	 * 序列化
	 */
	private static final long serialVersionUID = -7469866596403135281L;

	/**
	 * 图书申诉标识
	 */
	private Long bookAppealId;
	
	/**
	 * 图书标识
	 */
	private Long bookId;
	
	/**
	 * 渠道标识
	 */
	private Long channelId;
	
	/**
	 * 申诉理由
	 */
	private String reason;
	
	/**
	 * 申诉人
	 */
	private Long declarant;
	
	/**
	 * 联系方式
	 */
	private String phone;
	
	/**
	 * 申诉提交时间
	 */
	private Date appealSubmitDate;
	
	/**
	 * 申诉状态
	 */
	private Integer appealState;
	
	/**
	 * 审核原因
	 */
	private String auditReason;
	
	/**
	 * 审核人
	 */
	private Long auditUser;
	
	/**
	 * 申诉人名称
	 */
	private String declarantName;
	
	/**
	 * 出版社名称
	 */
	private String agentName; 
	
	/**
	 * isbn
	 */
	private String isbn;
	
	/**
	 * 书籍名称
	 */
	private String bookName;
	
	/**
	 * 书籍信息
	 */
	private BookDto book;
	
	/**
	 * version
	 */
	private Integer version;
	
	/**
	 * 被诉人基本信息
	 */
	private List<BookDefendant> defendants;
	
	/**
	 * 刊物序号
	 */
	private String serialNumber;
	
	/**
	 * 申述人
	 */
	private Long createdUser;

	/**
	 * 图书类型标识
	 */
	private Long templetId;

	/**
	 * 是否有不一样运营的图书（同运营可以设置主副编辑）
	 */
	private Boolean haveDiffChannel;

	/**
	 * 运营名称
	 */
	private String channelName;

    /**
     * 是否社群书
     */
    private Boolean isBookGroup;

    private Integer addType;

    private Long secondTempletId;

	/**
	 * 三级分类id
	 */
	private Long thirdTempletId;
	/**
	 * 三级分类名称
	 */
	private String thirdTempletName;

	public Long getThirdTempletId() {
		return thirdTempletId;
	}

	public void setThirdTempletId(Long thirdTempletId) {
		this.thirdTempletId = thirdTempletId;
	}

	public String getThirdTempletName() {
		return thirdTempletName;
	}

	public void setThirdTempletName(String thirdTempletName) {
		this.thirdTempletName = thirdTempletName;
	}

	public Long getSecondTempletId() {
		return secondTempletId;
	}

	public void setSecondTempletId(Long secondTempletId) {
		this.secondTempletId = secondTempletId;
	}

	public Integer getAddType() {
		return addType;
	}

	public void setAddType(Integer addType) {
		this.addType = addType;
	}

	public Long getBookAppealId() {
		return bookAppealId;
	}

	public void setBookAppealId(Long bookAppealId) {
		this.bookAppealId = bookAppealId;
	}

	public Long getBookId() {
		return bookId;
	}

	public void setBookId(Long bookId) {
		this.bookId = bookId;
	}

	public Long getChannelId() {
		return channelId;
	}

	public void setChannelId(Long channelId) {
		this.channelId = channelId;
	}

	public String getReason() {
		return reason;
	}

	public void setReason(String reason) {
		this.reason = reason;
	}

	public Long getDeclarant() {
		return declarant;
	}

	public void setDeclarant(Long declarant) {
		this.declarant = declarant;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	public Date getAppealSubmitDate() {
		return appealSubmitDate;
	}

	public void setAppealSubmitDate(Date appealSubmitDate) {
		this.appealSubmitDate = appealSubmitDate;
	}

	public Integer getAppealState() {
		return appealState;
	}

	public void setAppealState(Integer appealState) {
		this.appealState = appealState;
	}

	public String getAuditReason() {
		return auditReason;
	}

	public void setAuditReason(String auditReason) {
		this.auditReason = auditReason;
	}

	public Long getAuditUser() {
		return auditUser;
	}

	public void setAuditUser(Long auditUser) {
		this.auditUser = auditUser;
	}

	public String getDeclarantName() {
		return declarantName;
	}

	public void setDeclarantName(String declarantName) {
		this.declarantName = declarantName;
	}

	public BookDto getBook() {
		return book;
	}

	public void setBook(BookDto book) {
		this.book = book;
	}

	public String getAgentName() {
		return agentName;
	}

	public void setAgentName(String agentName) {
		this.agentName = agentName;
	}

	public List<BookDefendant> getDefendants() {
		return defendants;
	}

	public void setDefendants(List<BookDefendant> defendants) {
		this.defendants = defendants;
	}

	public String getIsbn() {
		return isbn;
	}

	public void setIsbn(String isbn) {
		this.isbn = isbn;
	}

	public String getBookName() {
		return bookName;
	}

	public void setBookName(String bookName) {
		this.bookName = bookName;
	}

	public Integer getVersion() {
		return version;
	}

	public void setVersion(Integer version) {
		this.version = version;
	}

	public String getSerialNumber() {
		return serialNumber;
	}

	public void setSerialNumber(String serialNumber) {
		this.serialNumber = serialNumber;
	}

	public Long getCreatedUser() {
		return createdUser;
	}

	public void setCreatedUser(Long createdUser) {
		this.createdUser = createdUser;
	}

	public Long getTempletId() {
		return templetId;
	}

	public void setTempletId(Long templetId) {
		this.templetId = templetId;
	}

	public Boolean getHaveDiffChannel() {
		return haveDiffChannel;
	}

	public void setHaveDiffChannel(Boolean haveDiffChannel) {
		this.haveDiffChannel = haveDiffChannel;
	}

	public String getChannelName() {
		return channelName;
	}

	public void setChannelName(String channelName) {
		this.channelName = channelName;
	}

    public Boolean getIsBookGroup() {
        return isBookGroup;
    }

    public void setIsBookGroup(Boolean isBookGroup) {
        this.isBookGroup = isBookGroup;
    }

	@Override
	public String toString() {
		return "BookAppealDto{" +
				"bookAppealId=" + bookAppealId +
				", bookId=" + bookId +
				", channelId=" + channelId +
				", reason='" + reason + '\'' +
				", declarant=" + declarant +
				", phone='" + phone + '\'' +
				", appealSubmitDate=" + appealSubmitDate +
				", appealState=" + appealState +
				", auditReason='" + auditReason + '\'' +
				", auditUser=" + auditUser +
				", declarantName='" + declarantName + '\'' +
				", agentName='" + agentName + '\'' +
				", isbn='" + isbn + '\'' +
				", bookName='" + bookName + '\'' +
				", book=" + book +
				", version=" + version +
				", defendants=" + defendants +
				", serialNumber='" + serialNumber + '\'' +
				", createdUser=" + createdUser +
				", templetId=" + templetId +
				", haveDiffChannel=" + haveDiffChannel +
				", channelName='" + channelName + '\'' +
				", isBookGroup=" + isBookGroup +
				", addType=" + addType +
				", secondTempletId=" + secondTempletId +
				'}';
	}
}
