package com.pcloud.book.applet.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.pcloud.book.group.dto.WxWorkTeacherDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AppletRecordDTO {
    private Long id;

    @ApiModelProperty("微信用户id")
    private Long wechatUserId;

    @ApiModelProperty("1资讯 2编辑群  3 模板群 4 作品 5 应用 6 书刊 7 好书推荐 8 精选书单")
    private Integer recordType;

    @ApiModelProperty("权益id")
    private Long rightsSettingId;

    @ApiModelProperty("书籍id")
    private Long bookId;

    @ApiModelProperty("渠道id")
    private Long channelId;

    @ApiModelProperty("编辑id")
    private Long adviserId;

    @ApiModelProperty("来源id")
    private Long fromId;

    @ApiModelProperty("来源名称")
    private String fromName;

    @ApiModelProperty("资讯")
    private AppletNewsDTO appletNewsDTO;

    @ApiModelProperty("社群")
    private GroupActivity4AppletDTO appletGroupDTO;

    @ApiModelProperty("应用/作品")
    private AppletAppOrProductDTO appletAppOrProductDTO;

    @ApiModelProperty("书籍")
    private AppletUserBookcaseDTO appletUserBookcaseDTO;

    @ApiModelProperty("精选书单")
    private AppletBooklistDTO appletBooklistDTO;

    @ApiModelProperty("书单推荐")
    private AppletOuterBooklistDTO appletOuterBooklistDTO;

    @ApiModelProperty("企业微信客服")
    private WxWorkTeacherDTO wxWorkTeacherDTO;

    @ApiModelProperty("资源是否已经被删除 0 未删除，1 已删除")
    private Integer sourceDelete;

    @ApiModelProperty("公众号id")
    private Long accountSettingId;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createDate;

    @ApiModelProperty("是否删除 0 未删除 1删除")
    private Integer isDelete;

    @ApiModelProperty("应用或作品的跳转链接")
    private String linkUrl;

    @ApiModelProperty("上下架状态")
    private Integer showState;

    @ApiModelProperty("应用、作品类型")
    private String typeCode;

    @ApiModelProperty("用户量")
    private Integer userCount;

    @ApiModelProperty("点击量")
    private Integer clickCount;

    @ApiModelProperty("是否收藏")
    private Integer isCollect;

    @ApiModelProperty("应用、作品类型或资讯来源名称")
    private String typeName;

    @ApiModelProperty("书名")
    private String bookName;

    @ApiModelProperty("图书封面")
    private String coverImg;
}
