package com.pcloud.book.advertising.entity;

import java.util.Date;
import java.util.List;

import com.pcloud.book.advertising.dto.BookAndChannelDTO;
import com.pcloud.common.entity.BaseEntity;

/**
 * @author PENG
 */
public class AdvertisingAdviserPermission extends BaseEntity {

    private static final long serialVersionUID = 3864910610568657776L;

    /**
     * advertising_adviser_permission.id (唯一标识)
     */
    private Long id;

    /**
     * advertising_adviser_permission.adviser_id (编辑ID)
     */
    private Long adviserId;

    /**
     * advertising_adviser_permission.book_id (书刊ID)
     */
    private Long bookId;

    /**
     * 运营ID
     */
    private Long channelId;

    /**
     * advertising_adviser_permission.is_open (是否打开)
     */
    private Boolean isOpen;

    /**
     * advertising_adviser_permission.create_time (创建时间)
     */
    private Date createTime;

    /**
     * advertising_adviser_permission.update_time (修改时间)
     */
    private Date updateTime;

    /**
     * 是否是批量操作
     */
    private Boolean isBatchOperation;

    /**
     * bookId和channelId集合
     */
    private List<BookAndChannelDTO> bookAndChannelDTOS;

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public Long getAdviserId() {
        return adviserId;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Boolean getIsOpen() {
        return isOpen;
    }

    public void setIsOpen(Boolean isOpen) {
        this.isOpen = isOpen;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Boolean getIsBatchOperation() {
        return isBatchOperation;
    }

    public void setIsBatchOperation(Boolean isBatchOperation) {
        this.isBatchOperation = isBatchOperation;
    }

    public List<BookAndChannelDTO> getBookAndChannelDTOS() {
        return bookAndChannelDTOS;
    }

    public void setBookAndChannelDTOS(List<BookAndChannelDTO> bookAndChannelDTOS) {
        this.bookAndChannelDTOS = bookAndChannelDTOS;
    }

    @Override
    public String toString() {
        return "AdvertisingAdviserPermission{" +
                "id=" + id +
                ", adviserId=" + adviserId +
                ", bookId=" + bookId +
                ", channelId=" + channelId +
                ", isOpen=" + isOpen +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                ", isBatchOperation=" + isBatchOperation +
                ", bookAndChannelDTOS=" + bookAndChannelDTOS +
                "} " + super.toString();
    }
}