package com.pcloud.book.clock.biz;

import com.pcloud.book.clock.dto.BookClockInfoDTO;
import com.pcloud.book.clock.entity.BookClockInfo;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBean;
import com.pcloud.common.page.PageParam;

import java.util.Map;

import java.util.List;
import java.util.Map;

/**
 * @Author: hzk
 * @Date: 2019/5/24 14:50
 * @Version 1.0
 */
public interface BookClockBiz {

    /**
     * 关联作品/应用及微信群
     * @param bookClockInfo
     */
    Long createBookGroupClock(BookClockInfo bookClockInfo) throws BizException;

    /**
     * 修改关联关系
     * @param bookClockInfo
     * @throws BizException
     */
    void updateBookGroupClock(BookClockInfo bookClockInfo) throws BizException;

    /**
     * 获取关联的基本信息
     * @param bookClockInfoId
     * @return
     */
    BookClockInfoDTO getBookGroupClockBaseInfo(Long bookClockInfoId);

    /**
     * 获取该编辑已选的超级作者作品及应用
     * @param adviserId
     * @return
     */
    Map<String,List<BookClockInfoDTO>> getAdviserHasSelected(Long adviserId);


    /**
     * 获取关联作品/应用列表
     * @param pageParam
     * @param paramMap
     * @return
     */
    PageBean listBookGroupClock(PageParam pageParam, Map<String, Object> paramMap);

    /**
     * 发送微信群打卡群发消息
     * @param paramMap
     */
    void sendBookClockGroupMessage(Map<String, Object> paramMap);

    /**
     * 删除关联关系
     * @param bookClockInfoId
     * @param adviserId
     */
    void deleteBookGroupClock(Long bookClockInfoId,Long adviserId);

    /**
     * 处理关联应用的打卡的旧数据
     */
    void dealOldData4WeixinClock();

    /**
     * 处理关联作品的打卡的旧数据
     */
    void dealOldData4WeixinAtt();
}
