package com.pcloud.book.guide.mapper;

import com.pcloud.book.guide.entity.PcloudGuide;
import com.pcloud.book.guide.vo.PcloudGuideVO;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public interface PcloudGuideMapper {
    int deleteByPrimaryKey(Integer id);

    int insert(PcloudGuide record);

    int insertSelective(PcloudGuide record);

    PcloudGuide selectByPrimaryKey(Integer id);

    int updateByPrimaryKeySelective(PcloudGuide record);

    int updateByPrimaryKey(PcloudGuide record);

    Integer getMaxSeqNum(@Param("robotWxId") String robotWxId, @Param("pcloudClassifyId") Integer pcloudClassifyId);

    Integer getCount(@Param("robotWxId") String robotWxId, @Param("search") String search, @Param("pcloudClassifyId") Integer pcloudClassifyId);

    List<PcloudGuideVO> listPcloudGuide(@Param("pageNum") Integer pageNum, @Param("numPerPage") Integer numPerPage,
                                        @Param("robotWxId") String robotWxId, @Param("search") String search, @Param("pcloudClassifyId") Integer pcloudClassifyId);

    void updateSeqNum(@Param("id") Integer pcloudGuideId, @Param("seqNum") Integer seqNum);

    List<PcloudGuide> listByRobotId(String robotId);

    PcloudGuide getFirstByRobotId(@Param("robotId") String robotId, @Param("num") int num);

    List<Integer> listPcloudGuideIds(String robotWxId);

    PcloudGuide getFirstByClassifyId(@Param("pcloudClassifyId") Integer pcloudClassifyId, @Param("num") int num);
}