package com.pcloud.book.keywords.entity;

import com.pcloud.common.entity.BaseEntity;
import com.pcloud.contentcenter.resource.dto.ResourceOfficeItemDTO;
import com.pcloud.contentcenter.resource.dto.ResourcePdfItemDTO;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("非关键词回复项")
public class NotKeywordItem extends BaseEntity {

    @ApiModelProperty("模板id")
    private Long templateId;

    @ApiModelProperty("类型 1 文字  5素材")
    private Integer type;

    @ApiModelProperty("回复内容")
    private String content;

    @ApiModelProperty("资源id")
    private Long resourceId;

    @ApiModelProperty("资源链接")
    private String resourceUrl;

    @ApiModelProperty("资源名称")
    private String resourceName;

    @ApiModelProperty("资源类型编码")
    private String resourceTypeCode;

    @ApiModelProperty("资源类型名称")
    private String resourceTypeName;

    @ApiModelProperty("文件类型")
    private String fileType;

    @ApiModelProperty("pdf转码后的单张图片集合")
    private List<ResourcePdfItemDTO> resourcePdfItems;

    @ApiModelProperty("文件转码后的单张图片集合")
    private List<ResourceOfficeItemDTO> resourceOfficeItemDTOs;

}
