package com.pcloud.book.keywords.facade.impl;

import com.pcloud.book.keywords.biz.NotKeywordBiz;
import com.pcloud.book.keywords.entity.NotKeywordTemplate;
import com.pcloud.book.keywords.facade.NotKeywordFacade;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController("notKeywordFacade")
@RequestMapping("notKeyword")
public class NotKeywordFacadeImpl implements NotKeywordFacade {

    @Autowired
    private NotKeywordBiz notKeywordBiz;

    @ApiOperation("新增非关键词回复模板")
    @PostMapping("createNotKeywordTemplate")
    @Override
    public ResponseDto<?> createNotKeywordTemplate(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("非关键词回复模板") NotKeywordTemplate notKeywordTemplate
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        notKeywordBiz.createNotKeywordTemplate(notKeywordTemplate);
        return new ResponseDto<>();
    }

    @ApiOperation("删除非关键词回复模板")
    @GetMapping("deleteNotKeywordTemplate")
    @Override
    public ResponseDto<?> deleteNotKeywordTemplate(
            @RequestHeader("token") String token,
            @RequestParam @ApiParam("非关键词回复模板id") Long id
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        notKeywordBiz.deleteNotKeywordTemplate(id);
        return new ResponseDto<>();
    }

    @ApiOperation("获取非关键词回复模板列表")
    @GetMapping("getNotKeywordTemplateList")
    @Override
    public ResponseDto<?> getNotKeywordTemplateList(
            @RequestHeader("token") String token,
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(notKeywordBiz.getNotKeywordTemplateList(currentPage,numPerPage));
    }

    @ApiOperation("获取非关键词回复模板")
    @GetMapping("getNotKeywordTemplate")
    @Override
    public ResponseDto<?> getNotKeywordTemplate(
            @RequestHeader("token") String token,
            @RequestParam @ApiParam("非关键词回复模板id") Long id
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(notKeywordBiz.getNotKeywordTemplate(id));
    }


}
