package com.pcloud.book.mq.topic;

import com.pcloud.book.keywords.biz.BookKeywordBiz;
import com.pcloud.book.mq.config.MQTopicConumer;
import com.pcloud.book.pcloudkeyword.dao.PcloudRobotClassifyDao;
import com.pcloud.book.pcloudkeyword.dao.PcloudRobotDao;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobot;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobotClassify;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.cache.redis.JedisClusterUtils;
import com.pcloud.common.utils.string.StringUtil;
import com.pcloud.wechatgroup.message.dto.SendNotTextDTO;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;


@Slf4j
@Component("wxGroupSendNotTextListener")
@RabbitListener(queues = MQTopicConumer.WXGROUP_SEND_NOT_TEXT)
public class WxGroupSendNotTextListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(WxGroupSendNotTextListener.class);

    @Autowired
    private BookKeywordBiz bookKeywordBiz;
    @Autowired
    private PcloudRobotDao pcloudRobotDao;
    @Autowired
    private PcloudRobotClassifyDao pcloudRobotClassifyDao;

    @ParamLog("接收用户发送非文本消息")
    @RabbitHandler
    public void onMessage(SendNotTextDTO sendNotTextDTO) throws BizException {
        try {
            String userWxId = sendNotTextDTO.getWechatCreateUser();
            String ip = sendNotTextDTO.getIp();
            Integer code = sendNotTextDTO.getCode();
            String robotId = sendNotTextDTO.getWxId();
            if (StringUtil.isEmpty(userWxId)||StringUtil.isEmpty(robotId)||StringUtil.isEmpty(ip)){
                return;
            }
            // 缄默设置处理
            bookKeywordBiz.silenceProcess(userWxId, code, robotId);
            // 机器人自动唤醒
            bookKeywordBiz.robotWakeUp(userWxId, ip, code, robotId);
            //判断是否为平台端小号
            PcloudRobot pcloudRobot = pcloudRobotDao.getByWxId(sendNotTextDTO.getWxId());
            if (pcloudRobot!=null){
                //发送非关键词
                //查询该小号对应小号分类的关键词分类
                Long robotClassifyId=pcloudRobot.getRobotType().longValue();
                PcloudRobotClassify robotClassify = pcloudRobotClassifyDao.getById(robotClassifyId);
                if (robotClassify==null||robotClassify.getKeywordClassifyId()==null){
                    return;
                }
                Long pcloudClassifyId=robotClassify.getKeywordClassifyId();
                bookKeywordBiz.sendPcloudNotKeyWord(userWxId,ip,code,robotId,pcloudClassifyId);
            }

        } catch (Exception e) {
            LOGGER.error("接收用户发送非文本消息失败" + e.getMessage(), e);
        }
    }
}
