package com.pcloud.book.pcloudkeyword.dao.impl;

import com.pcloud.book.pcloudkeyword.dao.PcloudRobotClassifyDao;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobotClassify;
import com.pcloud.book.pcloudkeyword.facade.response.PcloudRobotClassifyResponseVO;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class PcloudRobotClassifyDaoImpl extends BaseDaoImpl<PcloudRobotClassify> implements PcloudRobotClassifyDao {

    @Override
    public List<PcloudRobotClassifyResponseVO> listAllRobotClassify() {
        return this.getSqlSession().selectList("listAllRobotClassify");
    }

    @Override
    public void updateRobotClassifyKeywordClassify(Long id, Long keywordClassifyId) {
        Map<String,Object> map=new HashMap<>();
        map.put("id",id);
        map.put("keywordClassifyId",keywordClassifyId);
        getSessionTemplate().update(getStatement("updateRobotClassifyKeywordClassify"),map);
    }

    @Override
    public void updateWelcomeDuration(Long id, Integer welcomeDuration) {
        Map<String,Object> map=new HashMap<>();
        map.put("id",id);
        map.put("welcomeDuration",welcomeDuration);
        getSessionTemplate().update(getStatement("updateWelcomeDuration"),map);
    }
}
