package com.pcloud.book.pcloudkeyword.facade;

import com.pcloud.book.pcloudkeyword.biz.PcloudRobotClassifyBiz;
import com.pcloud.book.pcloudkeyword.dto.ClassifyWelcomeDTO;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobotClassify;
import com.pcloud.book.pcloudkeyword.facade.response.PcloudRobotClassifyResponseVO;
import com.pcloud.common.dto.ResponseDto;

import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

import java.util.List;

import javax.annotation.Resource;

@RestController
@RequestMapping("pcloudRobotClassify")
public class PcloudRobotClassifyFacade {

    @Resource
    private PcloudRobotClassifyBiz pcloudRobotClassifyBiz;

    @GetMapping("listClassify")
    public ResponseDto<List<PcloudRobotClassifyResponseVO>> listClassify() {
        List<PcloudRobotClassifyResponseVO> classify = pcloudRobotClassifyBiz.listAllRobotClassify();
        return new ResponseDto<>(classify);
    }

    @PostMapping("saveRobotClassify")
    public ResponseDto<Void> saveRobotClassify(@RequestParam("classifyName") String classifyName) {
        pcloudRobotClassifyBiz.saveRobotClassify(classifyName);
        return new ResponseDto<>();
    }

    @PostMapping("updateRobotClassify")
    public ResponseDto<Void> updateRobotClassify(@RequestBody PcloudRobotClassify classify) {
        pcloudRobotClassifyBiz.updateRobotClassify(classify);
        return new ResponseDto<>();
    }

    @GetMapping("getClassifyById")
    public ResponseDto<PcloudRobotClassify> getClassifyById(@RequestHeader("token") @ApiParam("token信息") String token,
                                                            @RequestParam("id") Long id) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(pcloudRobotClassifyBiz.getClassifyById(id));
    }

    @GetMapping("listClassifyByPage")
    public ResponseDto<?> listClassifyByPage(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage)  throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(pcloudRobotClassifyBiz.listClassifyByPage(currentPage, numPerPage));
    }

    @GetMapping("getClassifyWelcome")
    public ResponseDto<?> getClassifyWelcome(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("classifyId") @ApiParam("分类ID")  Long classifyId)  throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(pcloudRobotClassifyBiz.getClassifyWelcome(classifyId));
    }

    @PostMapping("updateClassifyWelcome")
    public ResponseDto<?> updateClassifyWelcome(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody ClassifyWelcomeDTO classifyWelcomeDTO)  throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudRobotClassifyBiz.updateClassifyWelcome(classifyWelcomeDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("更新小号分类关键词分类")
    @PostMapping("updateRobotClassifyKeywordClassify")
    public ResponseDto<?> updateRobotClassifyKeywordClassify(@RequestBody PcloudRobotClassify classify) {
        pcloudRobotClassifyBiz.updateRobotClassifyKeywordClassify(classify);
        return new ResponseDto<>();
    }

}
