package com.pcloud.book.pcloudkeyword.set;

import com.pcloud.book.consumer.content.ResourceConsr;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobotWelcome;
import com.pcloud.book.pcloudkeyword.enums.WelcomeReplyTypeEnum;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.contentcenter.resource.dto.ResourceDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("pcloudRobotSet")
public class PcloudRobotSet {

    @Autowired
    private ResourceConsr resourceConsr;

    @ParamLog("填充欢迎语回复")
    public void fillRobotWelcome(List<PcloudRobotWelcome> robotWelcomeList) {
        if(ListUtils.isEmpty(robotWelcomeList)){
            return;
        }
        List<Long> resourceIds=new ArrayList<>();
        for (PcloudRobotWelcome robotWelcome : robotWelcomeList){
            Integer type = robotWelcome.getReplyType();
            if (WelcomeReplyTypeEnum.RESOURCE.value.equals(type)){
                resourceIds.add(robotWelcome.getResourceId());
            }
        }
        Map<Long, ResourceDTO> resourceDTOMap=new HashMap<>();
        if (!ListUtils.isEmpty(resourceIds)){
            resourceDTOMap = resourceConsr.mapByIds(resourceIds);
        }
        for (PcloudRobotWelcome robotWelcome : robotWelcomeList){
            Integer type = robotWelcome.getReplyType();
            if (WelcomeReplyTypeEnum.RESOURCE.value.equals(type)){
                ResourceDTO resourceDTO = resourceDTOMap.get(robotWelcome.getResourceId());
                if (resourceDTO != null){
                    robotWelcome.setResourceName(resourceDTO.getResourceName());
                    robotWelcome.setResourceUrl(resourceDTO.getFileUrl());
                    robotWelcome.setResourceTypeCode(resourceDTO.getTypeCode());
                    robotWelcome.setResourceTypeName(resourceDTO.getTypeName());
                    robotWelcome.setFileType(resourceDTO.getFileType());
                    robotWelcome.setFileSize(resourceDTO.getFileSize());
                    robotWelcome.setResourcePdfItems(resourceDTO.getResourcePdfItems());
                    robotWelcome.setResourceOfficeItemDTOs(resourceDTO.getResourceOfficeItemDTOs());
                }
            }
        }
    }

}
