package com.pcloud.book.group.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Describe: 社群书数量dto
 * @Author: zhangdongwei
 * @Date: Create on 14:06 2020/1/2 0002
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("社群书数量dto")
public class BookGroupCountDTO {
    /**
     * 应用或作品id
     */
    @ApiModelProperty("应用或作品id")
    private Long serveId;
    /**
     * 类型（APP或PRODUCT）
     */
    @ApiModelProperty("类型（APP或PRODUCT）")
    private String serveType;
    /**
     * 编辑id
     */
    @ApiModelProperty("编辑id")
    private Long adviserId;
    /**
     * 社群书数量
     */
    @ApiModelProperty("社群书数量")
    private Integer bookGroupCount;
}
