package com.pcloud.book.advertising.dao;

import com.pcloud.book.advertising.dto.LinkRevertRecordDTO;
import com.pcloud.book.advertising.entity.AdvertisingLinkRevert;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * @描述：链接转换记录
 * @作者：zhuyajie
 * @创建时间：16:54 2019/10/10
 * @版本：1.0
 */
public interface AdvertisingLinkRevertDao extends BaseDao<AdvertisingLinkRevert> {

    /**
     * 转码记录列表
     * @param brandId
     * @return
     */
    List<LinkRevertRecordDTO> listRevertRecord(Long brandId);

    /**
     * 所有链接
     * @return
     */
    public List<AdvertisingLinkRevert> getAll();

    /**
     * 修改品牌方数据
     * @param linkRevert
     */
    void updateLinkBrandData(AdvertisingLinkRevert linkRevert);
}
