package com.pcloud.book.applet.dao;

import com.pcloud.book.applet.dto.AppletBooklistClassifyDTO;
import com.pcloud.book.applet.entity.AppletBooklistClassify;
import com.pcloud.book.applet.entity.AppletBooklistClassifyUser;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

public interface AppletBooklistClassifyDao extends BaseDao<AppletBooklistClassify> {

    /**
     * 获取最大排序值
     * @return
     */
    Integer getMaxSeq();
    /**
     * 获取所有书单栏目
     * @return
     */
    List<AppletBooklistClassifyDTO> getAllBooklistClassify(Boolean showState);

    /**
     * 用户选择书单栏目
     * @author：zhuyajie
     * @date：2020/5/14 11:15
     *  * @param null
     */
    void batchInsertUserBooklistClassify(List<AppletBooklistClassifyUser> booklistClassifyUsers);

    /**
     * 用户删除书单栏目
     *
     * @author：zhuyajie
     * @date：2020/5/14 11:15 * @param null
     */
    void deleteClassifyByWechatUesrId(Long wechatUserId);

    /**
     * 获取用户选择的书单栏目id
     *
     * @author：zhuyajie
     * @date：2020/5/14 11:18 * @param null
     */
    List<Long> getClassifyIdsByUserId(Long wechatUserId);

    /**
     * 获取用户选择的书单栏目
     *
     * @author：zhuyajie
     * @date：2020/5/14 11:32 * @param null
     */
    List<AppletBooklistClassifyDTO> getClassifysByUserId(Long wechatUserId);
}
