package com.pcloud.book.consumer.erp;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.common.utils.string.StringUtil;
import com.pcloud.erp.project.service.ProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository("erpConsr")
public class ErpConsr {
	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(ErpConsr.class);

	@Autowired
	private ProjectService projectService;

	@ParamLog("根据书名获取等级")
	public Integer getBookServiceLevel(String bookName) throws BizException {
		try {
			return ResponseHandleUtil.parseResponse(projectService.getBookServiceLevel(bookName), Integer.class);
		} catch (Exception e) {
			LOGGER.error("获取资源基本信息[resourceService.mapByPass]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_CONTENT_ERROR, "获取资源基本信息失败~!");
		}
	}

    @ParamLog("批量获取项目名称")
    public Map<Long, String> getBookNames(List<Long> bookIds) throws BizException {
        if(ListUtils.isEmpty(bookIds)){
            return new HashMap<>();
        }
        try {
            return ResponseHandleUtil.parseMap(projectService.getBookNames(bookIds), Long.class,String.class);
        } catch (Exception e) {
            LOGGER.error("批量获取项目名称[projectService.getBookNames]:" + e.getMessage(), e);
            throw new BookBizException(BookBizException.INVOKE_CONTENT_ERROR, "批量获取项目名称~!");
        }
    }

    @ParamLog("通过书名获取ERP端的bookId")
    public List<Long> getIdByBookName(String bookName) throws BizException {
        if(StringUtil.isEmpty(bookName)){
            return null;
        }
        try {
            return ResponseHandleUtil.parseListResponse(projectService.getIdByBookName(bookName), Long.class);
        } catch (Exception e) {
            LOGGER.error("通过书名获取ERP端的bookId[projectService.getIdByBookName]:" + e.getMessage(), e);
            throw new BookBizException(BookBizException.INVOKE_CONTENT_ERROR, "通过书名获取ERP端的bookId错误");
        }
    }

    @ParamLog("通过书名获取ERP端的bookId【模糊匹配】")
    public List<Long> getIdsByBookName(String bookName) throws BizException {
        if(StringUtil.isEmpty(bookName)){
            return null;
        }
        try {
            return ResponseHandleUtil.parseListResponse(projectService.getIdsByBookName(bookName), Long.class);
        } catch (Exception e) {
            LOGGER.error("通过书名获取ERP端的bookId[projectService.getIdByBookName]:" + e.getMessage(), e);
            throw new BookBizException(BookBizException.INVOKE_CONTENT_ERROR, "通过书名获取ERP端的bookId错误");
        }
    }

    @ParamLog("通过项目id获取bookId")
    public Long getProjectIdByBookId(Long bookId,Long adviserId,Long channelId){
        if(!NumberUtil.isNumber(bookId)){
            return null;
        }
        try {
            return ResponseHandleUtil.parseResponse(projectService.getProjectIdByBookId(bookId, adviserId, channelId), Long.class);
        } catch (Exception e) {
            LOGGER.error("通过项目id获取bookId[projectService.getBookIdByProjectId]:" + e.getMessage(), e);
            throw new BookBizException(BookBizException.INVOKE_CONTENT_ERROR, "通过项目id获取bookId 错误");
        }
    }
}
