package com.pcloud.book.group.facade.impl;

import com.pcloud.book.applet.dto.AppletGroupManageDTO;
import com.pcloud.book.group.biz.BookGroupBiz;
import com.pcloud.book.group.biz.BookGroupClassifyBiz;
import com.pcloud.book.group.biz.GroupQrcodeBiz;
import com.pcloud.book.group.dto.BookGroupClassifyDTO;
import com.pcloud.book.group.dto.GroupQrcode4ClassifyDTO;
import com.pcloud.book.group.dto.ListBookGroup4HealsDTO;
import com.pcloud.book.group.dto.ListClassify4WechatDTO;
import com.pcloud.book.group.facade.BookGroupClassifyFacade;
import com.pcloud.book.group.vo.*;
import com.pcloud.common.core.constant.SystemCode;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.BeanUtils;
import com.pcloud.common.utils.NumberUtil;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2019/4/16 21:02
 */
@RestController("bookGroupClassifyFacade")
@RequestMapping("bookGroupClassify")
public class BookGroupClassifyFacadeImpl implements BookGroupClassifyFacade {

    @Autowired
    private BookGroupClassifyBiz bookGroupClassifyBiz;
    @Autowired
    private BookGroupBiz bookGroupBiz;
    @Autowired
    private GroupQrcodeBiz groupQrcodeBiz;

    @Override
    @GetMapping("listAllClassify")
    public ResponseDto<List<ListClassifyVO>> listAllClassify(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId) {
        List<ListClassifyVO> listAllClassifys = bookGroupClassifyBiz.listAllClassify(bookGroupId);
        return new ResponseDto<>(listAllClassifys);
    }

    @Override
    @PostMapping("addClassify")
    public ResponseDto<?> addClassify(@RequestHeader("token") String token, @RequestBody AddClassifyVO addClassifyVO) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookGroupClassifyBiz.addClassify(addClassifyVO, partyId);
        return new ResponseDto<>();
    }

    @Override
    @PostMapping("updateClassify")
    public ResponseDto<?> updateClassify(@RequestHeader("token") String token, @RequestBody UpdateClassifyVO updateClassifyVO) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookGroupClassifyBiz.updateClassify(updateClassifyVO, partyId);
        return new ResponseDto<>();
    }

    @Override
    @GetMapping("getClassify")
    public ResponseDto<ClassifyVO> getClassify(@RequestHeader("token") String token, @RequestParam("classifyId") Long classifyId) throws BizException, PermissionException {
        ClassifyVO classifyVO = bookGroupClassifyBiz.getClassify(classifyId);
        return new ResponseDto<>(classifyVO);
    }

    @Override
    @GetMapping("deleteClassify")
    public ResponseDto<?> deleteClassify(@RequestHeader("token") String token, @RequestParam("classifyId") Long classifyId) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookGroupClassifyBiz.deleteClassify(classifyId, partyId);
        return new ResponseDto<>();
    }

    @Override
    @PostMapping("updateClassifyRank")
    public ResponseDto<?> updateClassifyRank(@RequestHeader("token") String token, @RequestBody UpdateRankVO updateRankVO) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookGroupClassifyBiz.updateClassifyRank(updateRankVO, partyId);
        return new ResponseDto<>();
    }

    @Override
    @GetMapping("listClassify")
    public ResponseDto<List<ClassifyNameVO>> listClassify(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId) {
        List<ClassifyNameVO> classifyNameVOS = bookGroupClassifyBiz.listClassify(bookGroupId);
        return new ResponseDto<>(classifyNameVOS == null ? new ArrayList<>() : classifyNameVOS);
    }

    @Override
    @GetMapping("getClassifyAndGroupCount")
    public ResponseDto<ClassifyAndGroupCountVO> getClassifyAndGroupCount(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId) {
        ClassifyAndGroupCountVO classifyAndGroupCountVO = bookGroupClassifyBiz.getClassifyAndGroupCount(bookGroupId);
        return new ResponseDto<>(classifyAndGroupCountVO == null ? new ClassifyAndGroupCountVO() : classifyAndGroupCountVO);
    }

    @Override
    @GetMapping("getClassifyAndUserCount")
    public ResponseDto<ClassifyAndUserCountVO> getClassifyAndUserCount(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId) {
        ClassifyAndUserCountVO classifyAndGroupCountVO = bookGroupClassifyBiz.getClassifyAndUserCount(bookGroupId);
        return new ResponseDto<>(classifyAndGroupCountVO == null ? new ClassifyAndUserCountVO() : classifyAndGroupCountVO);
    }

    @Override
    @GetMapping("listClassify4Wechat")
    public ResponseDto<List<ListClassify4WechatVO>> listClassify4Wechat(@CookieValue("userInfo") String userInfo, @RequestParam("bookGroupId") Long bookGroupId) {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        List<ListClassify4WechatVO> listClassify4WechatVOS = bookGroupClassifyBiz.listClassify4Wechat(bookGroupId, wechatUserId);
        return new ResponseDto<>(listClassify4WechatVOS);
    }

    @Override
    @GetMapping("listClassify4APP")
    public ResponseDto<List<ListClassify4WechatVO>> listClassify4APP(@CookieValue("userInfo") String userInfo, @RequestParam("bookGroupId") Long bookGroupId) {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        List<ListClassify4WechatVO> listClassify4WechatVOS = bookGroupClassifyBiz.listClassify4APP(bookGroupId, wechatUserId);
        return new ResponseDto<>(listClassify4WechatVOS);
    }

    @Override
    @GetMapping("getGroupQrcode4ClassifyWechat")
    public ResponseDto<GroupQrcode4ClassifyVO> getGroupQrcode4ClassifyWechat(@CookieValue("userInfo") String userInfo, @RequestParam("classifyId") Long classifyId) {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        GroupQrcode4ClassifyVO groupQrcode4ClassifyVO = bookGroupClassifyBiz.getGroupQrcode4ClassifyWechat(classifyId, wechatUserId);
        return new ResponseDto<>(groupQrcode4ClassifyVO == null ? new GroupQrcode4ClassifyVO() : groupQrcode4ClassifyVO);
    }

    @Override
    @GetMapping("getGroupQrcode4Applet")
    public ResponseDto<GroupQrcode4ClassifyVO> getGroupQrcode4Applet(@CookieValue("userInfo") String userInfo, @RequestParam("classifyId") Long classifyId) {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        GroupQrcode4ClassifyVO groupQrcode4ClassifyVO = bookGroupClassifyBiz.getGroupQrcode4Applet(classifyId, wechatUserId);
        return new ResponseDto<>(groupQrcode4ClassifyVO == null ? new GroupQrcode4ClassifyVO() : groupQrcode4ClassifyVO);
    }

    @Override
    @PostMapping("listGroupClassifyByAdviser")
    public ResponseDto<PageBeanNew<BookGroupClassifyVO>> listGroupClassifyByAdviser(@RequestHeader("token") String token, @RequestBody @ApiParam("获取分类列表参数") ListGroupClassifyParam listGroupClassifyParam) throws PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        PageBeanNew<BookGroupClassifyVO> pageBeanNew = bookGroupClassifyBiz.listGroupClassifyByAdviser(listGroupClassifyParam, adviserId);
        return new ResponseDto<>(pageBeanNew);
    }

    @Override
    @PostMapping("listBookGroupQrcodeStatistic")
    public ResponseDto<PageBeanNew<BookGroupQrcodeStatisticVO>> listBookGroupQrcodeStatistic(@RequestHeader("token") String token, @RequestBody ListBookGroupQrcodeParamVO listBookGroupQrcodeParamVO) throws PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        PageBeanNew<BookGroupQrcodeStatisticVO> pageBeanNew = bookGroupClassifyBiz.listBookGroupQrcodeStatistic(listBookGroupQrcodeParamVO, adviserId);
        return new ResponseDto<>(pageBeanNew);
    }

    @Override
    @PostMapping("bookGroupQrcodeStatisticExport")
    public ResponseDto<?> bookGroupQrcodeStatisticExport(@RequestHeader("token") String token, @RequestBody ListBookGroupQrcodeExportParamVO listBookGroupQrcodeExportParamVO) throws PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookGroupClassifyBiz.bookGroupQrcodeStatisticExport(listBookGroupQrcodeExportParamVO.getClassifyIds(), listBookGroupQrcodeExportParamVO.getBookGroupId(), adviserId);
        return new ResponseDto<>();
    }

    @Override
    @GetMapping("getStatistic4Adviser")
    public ResponseDto<StatisticVO> getStatistic4Adviser(@RequestHeader("token") String token) throws PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        StatisticVO statisticVO = bookGroupClassifyBiz.getStatistic4Adviser(adviserId);
        return new ResponseDto<>(statisticVO == null ? new StatisticVO() : statisticVO);
    }

    @Override
    @PostMapping("listAdviserClassify")
    public ResponseDto<PageBeanNew<AdviserClassifyVO>> listAdviserClassify(@RequestHeader("token") String token, @RequestBody AdviserClassifyParam adviserClassifyParam) throws PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(bookGroupClassifyBiz.listAdviserClassify(adviserId, adviserClassifyParam));
    }

    @ApiOperation("关闭或开启学习报告")
    @GetMapping("updateHasOpenLearningReport")
    @Override
    public ResponseDto<?> updateHasOpenLearningReport(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("classifyId") @ApiParam("分类id") Long classifyId,
            @RequestParam("hasOpenLearningReport") @ApiParam("是否开启学习报告") Boolean hasOpenLearningReport
    ) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookGroupClassifyBiz.updateHasOpenLearningReport(classifyId,hasOpenLearningReport,partyId);
        return new ResponseDto<>();
    }

    @ApiOperation("获取群分类学习报告相关列表")
    @GetMapping("listClassifyForLearningReport")
    @Override
    public ResponseDto<?> listClassifyForLearningReport(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页条数") Integer numPerPage,
            @RequestParam(value = "keyword", required = false) @ApiParam("关键词") String keyword
    ) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(bookGroupClassifyBiz.listClassifyForLearningReport(currentPage,numPerPage,keyword,partyId));
    }


    @ApiOperation("拖动排序")
    @PostMapping("dragSortClassify")
    @Override
    public ResponseDto<?> dragSortClassify(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody List<Long> classifyIds
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookGroupClassifyBiz.dragSortClassify(classifyIds);
        return new ResponseDto<>();
    }


    @Override
    @GetMapping("clickClassify")
    public ResponseDto<?> clickClassify(@CookieValue("userInfo") String userInfo, @RequestParam("bookGroupId") Long bookGroupId,
                                       @RequestParam("classifyId") Long classifyId) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        bookGroupClassifyBiz.clickClassify(wechatUserId,bookGroupId,classifyId);
        return new ResponseDto<>();
    }

    @Override
    @GetMapping("getClassifyIngoreDelete")
    public ResponseDto<?> getClassifyIngoreDelete(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        List<ListClassifyVO> classifyVOS = bookGroupClassifyBiz.getClassifyIngoreDelete(bookGroupId);
        return new ResponseDto<>(classifyVOS);
    }

    @ApiOperation("根据类型获取分类数量")
    @GetMapping("getClassifyCountByJoinGroupType")
    @Override
    public ResponseDto<?> getClassifyCountByJoinGroupType(
            @RequestHeader("token") String token,
            @RequestParam(value = "joinGroupType", required = false) Integer joinGroupType
    ) throws PermissionException {
        String systemCode = (String) SessionUtil.getVlaue(token, SessionUtil.SYSTEM_CODE);
        if (!SystemCode.pcloud.code.equalsIgnoreCase(systemCode)) {
            throw new PermissionException(PermissionException.PERMISSION_NOT_FOUND);
        }
        return new ResponseDto<>(bookGroupClassifyBiz.getClassifyCountByJoinGroupType(joinGroupType));
    }

    @Override
    @PostMapping("getClassifyByIds4Heals")
    public ResponseDto<Map<Long, String>> getClassifyByIds4Heals(@RequestBody List<Long> classifyIds) {
        Map<Long, String> groupClassifyMap =  bookGroupClassifyBiz.getClassifyByIds(classifyIds);
        return new ResponseDto<>(groupClassifyMap);
    }

    @Override
    @RequestMapping(value = "/getBookGroupClassifyByAdviserId", method = RequestMethod.GET)
    public ResponseDto<PageBeanNew<BookGroupClassifyDTO>> getBookGroupClassifyByAdviserId(  @RequestParam(value = "adviserId") Long adviserId,
                                                                                            @RequestParam(value = "classify",required = false) String classify,
                                                                                            @RequestParam(value = "currentPage") Integer currentPage ,
                                                                                            @RequestParam(value = "numPerPage") Integer numPerPage) throws BizException {
        PageBeanNew<BookGroupClassifyDTO> pageBeanNew=bookGroupBiz.getBookGroupClassifyByAdviserId(adviserId,classify,currentPage,numPerPage);
        return new ResponseDto<>(pageBeanNew);
    }

    @Override
    @RequestMapping(value = "/getQrcodeByClassifyId4Heals", method = RequestMethod.GET)
    public ResponseDto<List<GroupQrcode4ClassifyDTO>> getQrcodeByClassifyId4Heals(@RequestParam(value = "classifyId") Long classifyId) throws BizException {
        List<GroupQrcode4ClassifyDTO> list=bookGroupClassifyBiz.getQrcodeByClassifyId4Heals(classifyId);
        return new ResponseDto<>(list);
    }

    @Override
    @RequestMapping(value = "/getQrcodeByClassifyIds4Heals", method = RequestMethod.POST)
    public ResponseDto<List<GroupQrcode4ClassifyDTO>> getQrcodeByClassifyIds4Heals(@RequestBody List<Long> classifyIds) throws BizException {
        List<GroupQrcode4ClassifyDTO> list=bookGroupClassifyBiz.getQrcodeByClassifyIds4Heals(classifyIds);
        return new ResponseDto<>(list);
    }

    @Override
    @GetMapping("getQrcodeInfo4Heals")
    public ResponseDto<GroupQrcode4ClassifyDTO> getQrcodeInfo4Heals(@RequestParam("wechatUserId") Long wechatUserId,
                                                                    @RequestParam("classifyId") Long classifyId) throws BizException {
        GroupQrcode4ClassifyVO groupQrcode4ClassifyVO = bookGroupClassifyBiz.getGroupQrcode4ClassifyWechat(classifyId, wechatUserId);
        GroupQrcode4ClassifyDTO groupQrcode4ClassifyDTO=new GroupQrcode4ClassifyDTO();
        if(null!=groupQrcode4ClassifyVO){
            BeanUtils.copyProperties(groupQrcode4ClassifyVO,groupQrcode4ClassifyDTO);
        }
        return new ResponseDto<>(groupQrcode4ClassifyDTO);
    }

    @Override
    @GetMapping("listGroupClassify4Pcloud")
    public ResponseDto<PageBeanNew<PcloudBookGroupClassifyVO>>  listGroupClassify4Pcloud(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam(value = "name", required = false) @ApiParam("群分类名 | 书刊名") String name,
            @RequestParam(value = "proLabelId", required = false) @ApiParam("专业标签") Long proLabelId,
            @RequestParam(value = "depLabelId", required = false) @ApiParam("深度标签") Long depLabelId,
            @RequestParam(value = "purLabelId", required = false) @ApiParam("目的") Long purLabelId,
            @RequestParam(value = "firstClassifyId", required = false) @ApiParam("分类") Long firstClassifyId,
            @RequestParam(value = "gradeLabelId", required = false) @ApiParam("年级") Long gradeLabelId,
            @RequestParam(value = "subjectLabelId", required = false) @ApiParam("科目") Long subjectLabelId,
            @RequestParam(value = "agentId", required = false) @ApiParam("出版社") Long agentId,
            @RequestParam(value = "adviserId", required = false) @ApiParam("编辑id") Long adviserId,
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage,
            @RequestParam(value = "cityCode",required = false) String cityCode
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(bookGroupClassifyBiz.listGroupClassify4Pcloud(name, proLabelId, depLabelId, purLabelId,
                firstClassifyId, gradeLabelId, subjectLabelId, agentId,adviserId,currentPage, numPerPage,cityCode));
    }

    @Override
    @GetMapping("getGroupQrcodeByClassify")
    public ResponseDto<String> getGroupQrcodeByClassify(@RequestHeader("token") String token, @RequestParam("classifyId") Integer classifyId) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(groupQrcodeBiz.getChangeGroupQrCode(Long.valueOf(classifyId)));
    }

    @PostMapping("listClassify4Heals")
    public ResponseDto<List<ListClassify4WechatDTO>> listClassify4Heals(@RequestBody ListBookGroup4HealsDTO listBookGroup4HealsDTO) {
        Long wechatUserId = listBookGroup4HealsDTO.getWechatUserId();
        List<ListClassify4WechatDTO> listClassify4WechatVOS = bookGroupClassifyBiz.listClassify4Heals(listBookGroup4HealsDTO.getClassifyIds(), wechatUserId);
        return new ResponseDto<>(listClassify4WechatVOS);
    }

    @Override
    @PostMapping("getBookGroupClassifyByClassifyIds")
    public ResponseDto<List<BookGroupClassifyDTO>> getBookGroupClassifyByClassifyIds(@RequestBody List<Long> classifyIds) throws BizException, PermissionException {
        List<BookGroupClassifyDTO> list = bookGroupClassifyBiz.getBookGroupClassifyByClassifyIds(classifyIds);
        return new ResponseDto<>(list);
    }


    @GetMapping("getLocalGroup")
    public ResponseDto<PageBeanNew<AppletGroupManageDTO>> getLocalGroup(@CookieValue("userInfo") String userInfo,
                                                                        @RequestParam("numPerPage") Integer numPerPage,
                                                                        @RequestParam("currentPage")  Integer currentPage) throws BizException,
                                             PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if (!NumberUtil.isNumber(wechatUserId)) {
            throw new PermissionException("wechatUseId为空");
        }
        return new ResponseDto<PageBeanNew<AppletGroupManageDTO>>(groupQrcodeBiz.getLocalGroup(wechatUserId, numPerPage, currentPage));
    }

}
