package com.pcloud.book.group.vo;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * @ClassName com.pcloud.book.group.vo.PcloudBookGroupClassifyVO
 * @Author guiq
 * @Description 平台获取群分类信息
 * @Date 2020/6/10 15:54
 * @Version 1.0
 **/
@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class PcloudBookGroupClassifyVO {
    @ApiModelProperty("群分类ID")
    private Integer id;
    @ApiModelProperty("群分类名称")
    private String classify;
    @ApiModelProperty("群分类介绍")
    private String classifyIntroduce;
    @ApiModelProperty("销售价")
    private BigDecimal price;
    @ApiModelProperty("群个数")
    private Integer groupCount;
    @ApiModelProperty("出版社Id")
    private Long agentId;
    @ApiModelProperty("出版社")
    private String agentName;
    @ApiModelProperty("编辑账号名")
    private Long adviserId;
    @ApiModelProperty("编辑账号名")
    private String adviserName;
    @ApiModelProperty("电话")
    private String phone;
    @ApiModelProperty("图片")
    private String groupPic;
    @ApiModelProperty("城市编码")
    private String cityCode;

    @ApiModelProperty("城市名称")
    private String cityName;

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getClassify() {
        return classify;
    }

    public void setClassify(String classify) {
        this.classify = classify;
    }

    public String getClassifyIntroduce() {
        return classifyIntroduce;
    }

    public void setClassifyIntroduce(String classifyIntroduce) {
        this.classifyIntroduce = classifyIntroduce;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Integer getGroupCount() {
        return groupCount;
    }

    public void setGroupCount(Integer groupCount) {
        this.groupCount = groupCount;
    }

    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public String getAdviserName() {
        return adviserName;
    }

    public void setAdviserName(String adviserName) {
        this.adviserName = adviserName;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Long getAdviserId() {
        return adviserId;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    public String getGroupPic() {
        return groupPic;
    }

    public void setGroupPic(String groupPic) {
        this.groupPic = groupPic;
    }

    @Override
    public String toString() {
        return "PcloudBookGroupClassifyVO{" +
                "id=" + id +
                ", classify='" + classify + '\'' +
                ", classifyIntroduce='" + classifyIntroduce + '\'' +
                ", price=" + price +
                ", groupCount=" + groupCount +
                '}';
    }
}
