package com.pcloud.book.record.biz;

import com.pcloud.book.record.entity.AreaStatistics;
import com.pcloud.book.record.entity.BookBrowseRecord;
import com.pcloud.book.record.entity.BookDetail;
import com.pcloud.book.record.entity.BookDetailDTO;
import com.pcloud.book.record.entity.BookMapStatistics;
import com.pcloud.book.record.entity.MapData;
import com.pcloud.book.record.entity.RegionMap;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import java.util.List;
import java.util.Map;

public interface BookBrowseRecordBiz {

    void addBookRecord(BookBrowseRecord bookBrowseRecord);

    void addBookRecord4BookId(BookBrowseRecord bookBrowseRecord);

    List<BookMapStatistics> getBookCount4Country(String regionCode);

    AreaStatistics getAreaStatistics(String regionCode, Integer areaCode);

    PageBeanNew<BookDetail> getBookDetail(String regionCode, Integer areaCode, PageParam pageParam,
            String bookName, Long agentId, Long bookClassifyId);

    void addJsonData();

    PageBeanNew<MapData> getJsonData(String regionCode, Integer currentPage, Integer numPerPage);

    Map<String, List<RegionMap>> getCitysByPY(String keyword);

    void handleOldData();

    Map<String, RegionMap> getCitysByCodes(List<String> cityCodes);

    BookBrowseRecord getCityByIP(String ip);
}
