package com.pcloud.book.rightsSetting.dao.impl;

import com.pcloud.book.rightsSetting.dao.RightsSettingItemDao;
import com.pcloud.book.rightsSetting.dto.ReadTypeCountDTO;
import com.pcloud.book.rightsSetting.entity.RightsSettingClassify;
import com.pcloud.book.rightsSetting.entity.RightsSettingItem;
import com.pcloud.common.core.dao.BaseDaoImpl;

import com.pcloud.common.utils.ListUtils;
import java.util.ArrayList;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @描述：每周/长期权益(RightsSettingItem)表数据库访问层
 * @作者：zhuyajie
 * @创建时间：17:19 2020/4/19
 * @版本：1.0
 */
@Component
public class RightsSettingItemDaoImpl extends BaseDaoImpl<RightsSettingItem> implements RightsSettingItemDao {
    @Override
    public List<RightsSettingItem> queryAll(RightsSettingItem rightsSettingItem) {
        return getSessionTemplate().selectList(getStatement("queryAll"), rightsSettingItem);
    }

    @Override
    public int deleteByRightsSettingId(Long rightsSettingId,String rightsType) {
        Map<String,Object> map = new HashMap<>();
        map.put("rightsSettingId",rightsSettingId);
        map.put("rightsType", rightsType);
        return getSessionTemplate().delete(getStatement("deleteByRightsSettingId"), map);
    }

    @Override
    public List<RightsSettingClassify> getAllRightsClassify(String rightsType) {
        Map<String,Object> map = new HashMap<>();
        map.put("rightsType",rightsType);
        return getSessionTemplate().selectList(getStatement("getAllRightsClassify"), map);
    }

    @Override
    public List<RightsSettingItem> getItemByRightsIdAndType(Long rightsSettingId, String rightsType) {
        Map<String,Object> map = new HashMap<>();
        map.put("rightsSettingId",rightsSettingId);
        map.put("rightsType",rightsType);
        return getSessionTemplate().selectList(getStatement("getItemByRightsIdAndType"), map);
    }

    @Override
    public List<RightsSettingItem> getItemsByRightsSettingId4Read(Long rightsSettingId, String rightsType) {
        Map<String,Object> map = new HashMap<>();
        map.put("rightsSettingId",rightsSettingId);
        map.put("rightsType",rightsType);
        return getSessionTemplate().selectList(getStatement("getItemsByRightsSettingId4Read"), map);
    }

    @Override
    public ReadTypeCountDTO getCount4Item(Long rightsSettingId) {
        return getSessionTemplate().selectOne(getStatement("getCount4Item"),rightsSettingId);
    }

    @Override
    public Map<Long, RightsSettingClassify> getRightsClassifyMap(ArrayList<Long> ids) {
        if (ListUtils.isEmpty(ids)){
            return new HashMap<>();
        }
        return getSessionTemplate().selectMap(getStatement("getRightsClassifyMap"),ids,"id");
    }

    @Override
    public List<RightsSettingItem> getItemsByClassify(Long firstClassify, Long secondClassify, Long gradeLabelId, Long subjectLabelId, Long volLabelId, String rightsType, Integer readType, Long rightsClassifyId) {
        Map<String,Object> map = new HashMap<>();
        map.put("firstClassify",firstClassify);
        map.put("secondClassify",secondClassify);
        map.put("gradeLabelId",gradeLabelId);
        map.put("subjectLabelId",subjectLabelId);
        map.put("volLabelId",volLabelId);
        map.put("rightsType",rightsType);
        map.put("readType",readType);
        map.put("rightsClassifyId",rightsClassifyId);
        return getSessionTemplate().selectList(getStatement("getItemsByClassify"), map);
    }
}
