package com.pcloud.book.rightsSetting.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.validation.constraints.Size;
import lombok.Data;
import org.hibernate.validator.constraints.Range;

@Data
@ApiModel
public class RightsReadType {
    private Long id;

    @ApiModelProperty("权益id")
    private Long rightsSettingId;

    @ApiModelProperty("阅读类型 1，轻松 2 高效  3 深度")
    @Range(min = 1,max = 3,message = "阅读类型只能是轻松、高效和深度")
    private Integer readType;

    @ApiModelProperty("描述")
    @Size(max = 30,message="描述最多30个字")
    private String description;

    @ApiModelProperty("学习时长1-10")
    @Range(min = 1,max = 10,message = "学习时长只能选择1-10")
    private Integer learningLength;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date updateTime;

    @ApiModelProperty("权益数量")
    private Integer rightsCount;
}