package com.pcloud.book.rightsSetting.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.applet.dto.AppletNewsDTO;
import com.pcloud.book.custom.entity.CustomPlan;
import com.pcloud.book.skill.dto.GroupActivity4AppletDTO;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 每周/长期权益(RightsSettingItem)实体类
 *
 * @author zhuyajie
 * @since 2020-04-19 17:11:38
 */
@Data
public class RightsSettingItem extends BaseEntity {
    private static final long serialVersionUID = -10992603018190329L;
    
    private Long id;
    /**
    * 权益id
    */
    private Long rightsSettingId;
    /**
    * 权益类型（每周WEEK/长期LONG_TERM）
    */
    private String rightsType;
    /**
     * 权益分类
     */
    private Long rightsClassifyId;
    /**
    * 权益描述
    */
    private String description;
    /**
    * 创建时间
    */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;
    /**
     * 开启
     */
    private Integer openState;

    /**
     * 权益标题
     */
    private String title;
    /**
     * 资讯
     */
    private List<AppletNewsDTO> appletNewsDTOS;

    @ApiModelProperty("本书阅读计划开关 0关闭 1开启")
    private Integer isOpen;

    @ApiModelProperty("服务说明")
    private String serviceDesc;

    @ApiModelProperty("定制服务方案集合")
    private List<CustomPlan> customPlanList;

    @ApiModelProperty("唯一键")
    private String uuid;

    @ApiModelProperty("书刊id")
    private Long bookId;

    @ApiModelProperty("社群")
    private GroupActivity4AppletDTO groupActivity4AppletDTO;

    @ApiModelProperty("社群")
    private List<GroupActivity4AppletDTO> groupActivity4AppletList;

    @ApiModelProperty("服务类型；GROUP、NEWS、PLAN")
    private String serveType;
    /**
     * 轻松阅读
     */
    private Boolean easyRead;
    /**
     * 高效阅读
     */
    private Boolean efficientRead;
    /**
     * 深度阅读
     */
    private Boolean deepRead;
    /**
     * 阅读方式1轻松2高效3深度
     */
    private Integer readType;
}