package com.pcloud.book.timecontrol.facade.impl;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.timecontrol.biz.TaskPrizeBiz;
import com.pcloud.book.timecontrol.vo.SaveTaskPrizeVO;
import com.pcloud.book.timecontrol.vo.request.SavePrize4TaskItemVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Optional;

@RequestMapping("taskPrize")
@RestController("timeControlPrizeFacade")
public class TimeControlPrizeFacadeImpl {

    @Autowired
    private TaskPrizeBiz taskPrizeBiz;

    @ApiOperation(value = "保存累计奖励")
    @PostMapping("saveTaskPrize")
    ResponseDto<?> saveTaskPrize(@RequestHeader String token, @RequestBody SaveTaskPrizeVO saveTaskPrizeVO) throws PermissionException {
        Map<String, Object> token4Redis = SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(taskPrizeBiz.saveTaskPrize(saveTaskPrizeVO));
    }

    @ApiOperation(value = "获取任务累计奖励")
    @GetMapping("getPrize4Task")
    ResponseDto<?> getPrize4Task(@RequestHeader String token, @RequestParam("taskId") Integer taskId) throws PermissionException {
        Map<String, Object> token4Redis = SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(taskPrizeBiz.getPrize4Task(taskId));
    }

    @ApiOperation(value = "保存单次任务奖励")
    @PostMapping(value = "savePrize4TaskItem")
    ResponseDto<?> savePrize4TaskItem(@RequestHeader String token, @Validated @RequestBody SavePrize4TaskItemVO vo) throws PermissionException, BizException{
        Optional.ofNullable(vo).orElseThrow(() -> new BookBizException(BookBizException.ERROR, "参数不能为空"));
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        taskPrizeBiz.savePrize4TaskItem(vo);
        return new ResponseDto<>();
    }

    @ApiOperation(value = "获取单次任务奖励")
    @GetMapping("getPrize4TaskItem")
    ResponseDto<?> getPrize4TaskItem(@RequestHeader String token, @RequestParam Integer taskItemId) throws PermissionException {
        return new ResponseDto<>(taskPrizeBiz.getPrize4TaskItem(taskItemId));
    }

    @ApiOperation(value = "获取奖励配置目录")
    @GetMapping("listTaskItemPrize")
    ResponseDto<?> listTaskItemPrize(@RequestHeader String token,  @RequestParam Integer taskId) throws PermissionException {
        return new ResponseDto<>(taskPrizeBiz.listTaskItemPrize(taskId));
    }

    @ApiOperation(value = "预览奖状")
    @GetMapping("downloadCertificate")
    ResponseDto<?> downloadCertificate(@RequestHeader String token, @RequestParam Integer id, @RequestParam Integer type) {
        String url = taskPrizeBiz.downloadCertificate(id, type);
        String filePath="";
        try {
            URLEncoder.encode(url,"utf-8");
            filePath=new String(url.getBytes("iso8859-1"),"UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        return new ResponseDto<>(filePath);
    }

}
