package com.pcloud.book.applet.biz;

import com.pcloud.book.applet.dto.AppletNewsClassifyDTO;
import com.pcloud.book.applet.dto.AppletNewsCommentDTO;
import com.pcloud.book.applet.dto.AppletNewsCustomTagDTO;
import com.pcloud.book.applet.dto.AppletNewsDTO;
import com.pcloud.book.applet.dto.AppletNewsVO;
import com.pcloud.book.applet.dto.AppletThirdResourcesDTO;
import com.pcloud.book.applet.entity.AppletLinkClick;
import com.pcloud.book.applet.entity.AppletNews;
import com.pcloud.book.applet.entity.AppletNewsClassify;
import com.pcloud.book.applet.entity.AppletNewsComment;
import com.pcloud.book.applet.entity.AppletNewsCustomTag;
import com.pcloud.book.applet.vo.AppletNewsClassifyVO;
import com.pcloud.book.applet.vo.AppletNewsShowStateVO;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;
import java.util.Map;

/**
 * 小程序资讯
 */
public interface AppletNewsBiz {

    /**
     * 删除咨询标签
     * @param id 咨询标签唯一标识
     * @return
     */
    void deleteCategoryById(Long id);

    /**
     * 新增资讯分类
     * @param appletNewsClassify
     * @return
     */
    Long addAppletNewsClassify(AppletNewsClassify appletNewsClassify);

    /**
     * 修改资讯分类
     * @param appletNewsClassify
     */
    void updateAppletNewsClassify(AppletNewsClassify appletNewsClassify);

    /**
     * 删除资讯分类
     * @param id
     */
    void deleteNewsClassifyById(Long id);

    /**
     * 资讯栏目列表
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<AppletNewsClassifyDTO> listNewsClassify(Integer currentPage, Integer numPerPage, String name, Long agentId);

    /**
     * 添加资讯
     * @param appletNews
     * @return
     */
    Long addAppletNews(AppletNews appletNews);

    /**
     * 修改资讯
     * @param appletNews
     */
    void updateAppletNews(AppletNews appletNews);

    /**
     * 删除资讯
     * @param id
     */
    void deleteAppletNewsById(Long id);

    /**
     * 资讯列表
     * @param currentPage
     * @param numPerPage
     * @param name
     * @param cityCode
     * @return
     */
    PageBeanNew<AppletNewsDTO> listAppletNews(Integer currentPage, Integer numPerPage, String name,
                                              Long firstClassify, Long secondClassify,  Long thirdClassify, Long gradeLabelId,
                                              Long subjectLabelId, Long rightsClassifyId, String source, Integer showState, Long newsClassifyId,
                                              Long customTagId, String cityCode,Long agentId);

    /**
     * 获取所有资讯栏目
     * @return
     */
    List<AppletNewsClassifyDTO> getAllNewsClassify(Boolean showState, Long agentId);

    /**
     * 客户端资讯列表
     * @param currentPage
     * @param numPerPage
     * @param newsClassifyId
     * @return
     */
    PageBeanNew<AppletNewsDTO> listAppletNews4Wechat(Integer currentPage, Integer numPerPage, Long newsClassifyId, Long wechatUserId, Long officialAccountsId);

    /**
     * 添加资讯评论
     * @param appletNewsComment
     */
    void addAppletNewsComment(AppletNewsComment appletNewsComment, Long wechatUserId);

    /**
     * 查询资讯评论
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<AppletNewsCommentDTO> listNewsCommentByNewsId(Integer currentPage, Integer numPerPage, Long newsId);

    /**
     * 根据id查资讯详情
     * @param id
     * @return
     */
    AppletNewsDTO getNewsById(Long id);

    /**
     * 更新上架状态
     * @param appletNews
     */
    void updateNewsShowState(AppletNews appletNews);

    /**
     * 根据书刊分类标签权益分类查询
     * @param firstClassify
     * @param secondClassify
     * @param gradeLabelId
     * @param subjectLabelId
     * @param rightsType
     * @param thirdClassify
     * @return
     */
    List<AppletNewsDTO> getNewsByTempletLabel(Long firstClassify, Long secondClassify, Long gradeLabelId, Long subjectLabelId, String rightsType, Long agentId, Long thirdClassify);

    /**
     * 批量修改分类
     * @param appletNewsClassifyVO
     */
    void batchUpdateClassify(AppletNewsClassifyVO appletNewsClassifyVO);

    void batchUpdateShowState(AppletNewsShowStateVO appletNewsShowStateVO);

    void batchDeleteAppletNews(List<Long> appletNewsIds);


    /**
     * 根据id查询
     * @author：zhuyajie
     * @date：2020/4/26
     *  * @param null
     */
    AppletNewsVO getNewsVOById(Long newsId);

    /**
     * 资讯来源列表
     * @author：zhuyajie
     * @date：2020/4/27 14:46
     *  * @param null
     */
    List<String> getNewsSourceList(Long agentId);


    /**
     * 资讯和券的资源外链访问埋点
     * @author：zhuyajie
     * @date：2020/5/11 14:11
     *  * @param null
     */
    void addClickRecord(AppletLinkClick appletLinkClick);
    /**
     * 根据跳转地址查询链接编号
     * @author：zhuyajie
     * @date：2020/5/11 17:39
     *  * @param null
     */
    String getUrlNumberByUrl(String jumpUrl, Long agentId);
    /**
     * 用户选择资讯栏目
     * @author：zhuyajie
     * @date：2020/5/14 11:21
     *  * @param null
     */
    void addUserNewsClassify(List<Long> newsClassifyIds, Long wechatUserId, Long officialAccountsId);
    /**
     * 所有资讯栏目列表+用户选择的资讯栏目
     * @author：zhuyajie
     * @date：2020/5/14 11:21
     *  * @param null
     */
    List<AppletNewsClassifyDTO> getAllNewsClassify4Wechat(Long wechatUserId, Long officialAccountsId);
    /**
     * 用户选择的资讯栏目
     * @author：zhuyajie
     * @date：2020/5/14 11:21
     *  * @param null
     */
    List<AppletNewsClassifyDTO> getNewsClassifyByUser(Long wechatUserId, Long officialAccountsId);

    /**
     * 资讯统计分析
     * @author：zhuyajie
     * @date：2020/5/11 19:54
     *  * @param null
     */
    PageBeanNew<AppletNewsDTO> listAppletNews4Analysis(Integer currentPage, Integer numPerPage, String name,
                                                       Long firstClassify, Long secondClassify, Long gradeLabelId,
                                                       Long subjectLabelId, Integer linkOnly, Long rightsClassifyId,
                                                       String source, Integer browseQty, Integer clickQty, Long agentId, Long thirdClassify);

    /**
     *
     * @param appletNewsId
     * @return
     */
    Map<Long, AppletNewsDTO> getByIds(List<Long> appletNewsId);

    /**
     * 批量修改资讯栏目
     * @author：zhuyajie
     * @date：2020/5/26
     *  * @param null
     */
    void batchUpdateNewsClassify(AppletNewsClassifyVO appletNewsClassifyVO);

    /**
     * 批量更新自定义标识
     * @author：zhuyajie
     * @date：2020/6/9 17:52
     *  * @param null
     */
    void batchUpdateCustomTagId(List<Long> ids, Long customTagId, String customTag, Long agentId);
    /**
     * 新增自定义标识
     * @author：zhuyajie
     * @date：2020/6/9 17:52
     *  * @param null
     */
    Long insertCustomTag(AppletNewsCustomTag appletNewsCustomTag);
    /**
     * 修改自定义标识
     * @author：zhuyajie
     * @date：2020/6/9 17:52
     *  * @param null
     */
    void updateCustomTag(AppletNewsCustomTag appletNewsCustomTag);
    /**
     * 自定义标识列表
     * @author：zhuyajie
     * @date：2020/6/9 17:52
     *  * @param null
     */
    List<AppletNewsCustomTagDTO> getCustomTagList(Long agentId);
    /**
     * 根据标识id查资讯id列表
     * @author：zhuyajie
     * @date：2020/6/10 17:39
     *  * @param null
     */
    List<Long> getNewsIdListByCustomTagId(Long customTagId);

    /**
     * 批量插入资讯
     * @param appletNewsList
     */
    void batchInsert(List<AppletNews> appletNewsList);

    /**
     * 批量名片上下架
     * @param appletNewsShowStateVO
     */
    void batchUpdateCardShowState(AppletNewsShowStateVO appletNewsShowStateVO);

    /**
     * 更新名片是否上架状态
     * @param appletNews
     */
    void updateCardShowState(AppletNews appletNews);

    AppletNewsDTO getNewsById4Applet(Long newsId,Long wechatUserId);

    /**
     * 根据公众号id获取出版社id
     * @author：zhuyajie
     * @date：2020/7/20 15:38
     *  * @param null
     */
    Long getAgentIdByAccountId(Long officialAccountsId);

    /**
     * 添加默认推荐资讯栏目
     * @author：zhuyajie
     * @date：2020/8/5 10:53
     *  * @param null
     */
    void addDefaultAppletNewsClassify(Long agentId);

    /**
     *获取资讯 无论是否删除或下架
     * @param newsIds
     * @return
     */
    Map<Long, AppletNewsDTO>  getByIds4Record(List<Long> newsIds);

    void fillBrowseCount(List<AppletNewsDTO> recordList);

    /**
     * 查询第三方资源
     * @param thirdResourcesId
     * @return
     */
    AppletThirdResourcesDTO getThirdResourceById(Long thirdResourcesId);
    /**
     * H5首页-待上线应用点赞数量
     * @author：zhuyajie
     * @date：2021/6/1 11:18
     *  * @param null
     */
    Map<Long, Integer> getStayOnlineAppClickCount();

    /**
     * 批量获取资讯详情
     * @param newsIds
     * @return
     */
    List<AppletNews> getListByIds(List<Long> newsIds);
}
