package com.pcloud.book.applet.biz;

import com.pcloud.book.applet.entity.AppletSubscribeCount;
import com.pcloud.common.page.PageBeanNew;

/**
 * (AppletSubscribeCount)表服务接口
 *
 * @author wubo
 * @since 2021-08-03 09:37:45
 */
public interface AppletSubscribeCountBiz {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    AppletSubscribeCount getById(Long id);

    /**
     * 分页查询
     */
    PageBeanNew getList(Integer currentPage, Integer numPerPage);

    /**
     * 新增数据
     *
     * @param appletSubscribeCount 实例对象
     * @return 主键
     */
    Long insert(AppletSubscribeCount appletSubscribeCount);

    /**
     * 修改数据
     *
     * @param appletSubscribeCount 实例对象
     */
    void update(AppletSubscribeCount appletSubscribeCount);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void deleteById(Long id);

    /**
     * 通过主键软删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void softDeleteById(Long id);

    /**
     * 获取用户订阅次数
     * @param wechatUserId
     * @param recordType
     * @return
     */
    AppletSubscribeCount getByUserId(Long wechatUserId, Integer recordType);

    /**
     * 清除用户次数
     * @param wechatUserId
     * @param recordType
     */
    void clearSubscribeCount(Long wechatUserId, Integer recordType);
}