package com.pcloud.book.applet.dao;

import com.pcloud.book.applet.entity.AppletSubscribeCount;
import com.pcloud.common.core.dao.BaseDao;

/**
 * (AppletSubscribeCount)表数据库访问层
 *
 * @author wubo
 * @since 2021-08-03 09:37:45
 */
public interface AppletSubscribeCountDao extends BaseDao<AppletSubscribeCount> {
    int softDeleteById(Long id);

    /**
     * 获取用户订阅次数
     * @param wechatUserId
     * @param recordType
     * @return
     */
    AppletSubscribeCount getByUserId(Long wechatUserId, Integer recordType);

    void clearSubscribeCount(Long wechatUserId, Integer recordType);
}