package com.pcloud.book.copyright.entity;

import java.util.Date;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 书籍二维码授权表(BookSceneAuth)实体类
 *
 * @author makejava
 * @since 2021-10-19 14:14:22
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BookSceneAuth extends BaseEntity {

    private static final long serialVersionUID = 208406932124753490L;
    
    @ApiModelProperty("主键标识")
    private Long id;
    
    @ApiModelProperty("图书标识")
    private Long bookId;
    
    @ApiModelProperty("二维码id")
    private Long sceneId;
    
    @ApiModelProperty("运营标识")
    private Long channelId;
    
    @ApiModelProperty("编辑标识")
    private Long adviserId;
    
    @ApiModelProperty("最多激活人数")
    private Integer maxUserCount;
    
    @ApiModelProperty("激活次数用完后提示")
    private String fullUseTips;
    
    @ApiModelProperty("创建人")
    private Long createdUser;
    
    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    
    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;
    
}