package com.pcloud.book.group.dto;

import com.pcloud.common.dto.BaseDto;

import lombok.Data;

/**
 * @ClassName com.pcloud.book.group.dto.ThirdResourceOnBookDTO
 * @Author zhuyajie
 * @Description 第三方资源上书
 * @Date 2021/12/14 17:49
 **/
@Data
public class ResourceOnBookDTO extends BaseDto {

    private Long serveId;
    private String serveType;

    private Long sceneId;
    private String sceneName;
    private Long bookId;
    private String bookName;
    private String isbn;
    private Long adviserId;
    private String adviserName;
    private String agentName;
    private Long channelId;

    /**
     * 二维码扫码量 浏览量 读者量
     **/
    private Long scanNum = 0L;
    private Long readerNum = 0L;
    private Long browseNum = 0L;
    /**
     * 资源  点击量 点击人数
     **/
    private Integer resourceClickNum = 0;
    private Integer resourceClickUserNum = 0;
}
